/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.assembler;

import io.knotx.dataobjects.Fragment;
import io.knotx.fragments.FragmentContentExtractor;
import io.knotx.fragments.SnippetPatterns;

public enum UnprocessedFragmentStrategy {
    AS_IS{

        @Override
        protected String get(Fragment fragment, SnippetPatterns snippetPatterns) {
            return fragment.content();
        }
    }
    ,
    UNWRAP{

        @Override
        protected String get(Fragment fragment, SnippetPatterns snippetPatterns) {
            if (!fragment.isRaw() && snippetPatterns.getAnySnippetPattern().matcher(fragment.content()).matches()) {
                return "<!-- SNIPPET UNWRAPED START -->" + FragmentContentExtractor.unwrapContent(fragment) + "<!-- SNIPPET UNWRAPED STOP -->";
            }
            return fragment.content();
        }
    }
    ,
    IGNORE{

        @Override
        protected String get(Fragment fragment, SnippetPatterns snippetPatterns) {
            return snippetPatterns.getAnySnippetPattern().matcher(fragment.content()).matches() ? "<!-- SNIPPET IGNORED -->" : fragment.content();
        }
    };


    protected abstract String get(Fragment var1, SnippetPatterns var2);
}

