/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.dataobjects;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.knotx.dataobjects.ClientRequestConverter;
import io.knotx.http.UriHelper;
import io.knotx.util.DataObjectsUtil;
import io.knotx.util.MultiMapConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpServerRequest;
import java.util.Map;

@DataObject(generateConverter=true)
public class ClientRequest {
    private String path;
    private HttpMethod method;
    private MultiMap headers = MultiMap.caseInsensitiveMultiMap();
    private MultiMap params = MultiMap.caseInsensitiveMultiMap();
    private MultiMap formAttributes = MultiMap.caseInsensitiveMultiMap();

    public ClientRequest() {
    }

    public ClientRequest(JsonObject json) {
        ClientRequestConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public ClientRequest(ClientRequest request) {
        this.path = request.path;
        this.method = request.method;
        this.headers = MultiMap.caseInsensitiveMultiMap().setAll(request.headers);
        this.params = MultiMap.caseInsensitiveMultiMap().setAll(request.params);
        this.formAttributes = MultiMap.caseInsensitiveMultiMap().setAll(request.formAttributes);
    }

    public ClientRequest(HttpServerRequest serverRequest) {
        this.path = serverRequest.path();
        this.method = serverRequest.method();
        this.headers = MultiMap.caseInsensitiveMultiMap().setAll(serverRequest.headers());
        this.params = UriHelper.getParams(serverRequest.uri());
        this.formAttributes = MultiMap.caseInsensitiveMultiMap().setAll(serverRequest.formAttributes());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ClientRequestConverter.toJson(this, json);
        return json;
    }

    public String getPath() {
        return this.path;
    }

    public ClientRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public ClientRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return MultiMap.caseInsensitiveMultiMap().addAll(this.headers);
    }

    @GenIgnore
    public ClientRequest setHeaders(MultiMap headers) {
        this.headers = MultiMap.caseInsensitiveMultiMap().addAll(headers);
        return this;
    }

    @GenIgnore
    public MultiMap getParams() {
        return MultiMap.caseInsensitiveMultiMap().addAll(this.params);
    }

    @GenIgnore
    public ClientRequest setParams(MultiMap params) {
        this.params = MultiMap.caseInsensitiveMultiMap().addAll(params);
        return this;
    }

    @GenIgnore
    public MultiMap getFormAttributes() {
        return MultiMap.caseInsensitiveMultiMap().addAll(this.formAttributes);
    }

    @GenIgnore
    public ClientRequest setFormAttributes(MultiMap formAttributes) {
        this.formAttributes = MultiMap.caseInsensitiveMultiMap().addAll(formAttributes);
        return this;
    }

    public JsonObject getJsonHeaders() {
        return MultiMapConverter.toJsonObject(this.headers);
    }

    public void setJsonHeaders(JsonObject headers) {
        this.headers = MultiMapConverter.fromJsonObject(headers);
    }

    public JsonObject getJsonParams() {
        return MultiMapConverter.toJsonObject(this.params);
    }

    public void setJsonParams(JsonObject params) {
        this.params = MultiMapConverter.fromJsonObject(params);
    }

    public JsonObject getJsonFormAttributes() {
        return MultiMapConverter.toJsonObject(this.formAttributes);
    }

    public void setJsonFormAttributes(JsonObject formAttributes) {
        this.formAttributes = MultiMapConverter.fromJsonObject(formAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientRequest that = (ClientRequest)o;
        return Objects.equal((Object)this.path, (Object)that.path) && this.method == that.method && DataObjectsUtil.equalsMultiMap(this.headers, that.headers) && DataObjectsUtil.equalsMultiMap(this.params, that.params) && DataObjectsUtil.equalsMultiMap(this.formAttributes, that.formAttributes);
    }

    public int hashCode() {
        return 41 * Objects.hashCode((Object[])new Object[]{this.path, this.method}) + 37 * DataObjectsUtil.multiMapHash(this.headers) + 31 * DataObjectsUtil.multiMapHash(this.params) + DataObjectsUtil.multiMapHash(this.formAttributes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("method", (Object)this.method).add("headers", (Object)DataObjectsUtil.toString(this.headers)).add("params", (Object)DataObjectsUtil.toString(this.params)).add("formAttributes", (Object)DataObjectsUtil.toString(this.formAttributes)).toString();
    }
}

