/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.dataobjects;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.knotx.dataobjects.ClientResponseConverter;
import io.knotx.util.DataObjectsUtil;
import io.knotx.util.MultiMapConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.MultiMap;
import java.util.Map;

@DataObject(generateConverter=true)
public class ClientResponse {
    private int statusCode;
    private MultiMap headers = MultiMap.caseInsensitiveMultiMap();
    private Buffer body;

    public ClientResponse() {
    }

    public ClientResponse(JsonObject json) {
        ClientResponseConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ClientResponseConverter.toJson(this, json);
        return json;
    }

    public ClientResponse clearBody() {
        this.body = Buffer.buffer();
        return this;
    }

    public JsonObject toMetadataJson() {
        JsonObject json = new JsonObject();
        json.put("statusCode", Integer.valueOf(this.statusCode));
        json.put("headers", MultiMapConverter.toJsonObject(this.headers));
        return json;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ClientResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Buffer getBody() {
        return this.body;
    }

    public ClientResponse setBody(Buffer body) {
        this.body = body.copy();
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return MultiMap.caseInsensitiveMultiMap().addAll(this.headers);
    }

    @GenIgnore
    public ClientResponse setHeaders(MultiMap headers) {
        this.headers = MultiMap.caseInsensitiveMultiMap().addAll(headers);
        return this;
    }

    public JsonObject getJsonHeaders() {
        return MultiMapConverter.toJsonObject(this.headers);
    }

    public void setJsonHeaders(JsonObject headers) {
        this.headers = MultiMapConverter.fromJsonObject(headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientResponse)) {
            return false;
        }
        ClientResponse that = (ClientResponse)o;
        return Objects.equal((Object)this.statusCode, (Object)that.statusCode) && DataObjectsUtil.equalsMultiMap(this.headers, that.headers) && DataObjectsUtil.equalsBody(this.body, that.body);
    }

    public int hashCode() {
        return 31 * Objects.hashCode((Object[])new Object[]{this.statusCode, this.body}) + DataObjectsUtil.multiMapHash(this.headers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("headers", (Object)DataObjectsUtil.toString(this.headers)).add("body", (Object)this.body).toString();
    }
}

