/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.dataobjects;

import io.knotx.dataobjects.ClientResponse;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Map;

public class ClientResponseConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ClientResponse obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "body": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBody(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "jsonHeaders": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJsonHeaders(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "statusCode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setStatusCode(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    public static void toJson(ClientResponse obj, JsonObject json) {
        ClientResponseConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ClientResponse obj, Map<String, Object> json) {
        if (obj.getBody() != null) {
            json.put("body", Base64.getEncoder().encodeToString(obj.getBody().getBytes()));
        }
        if (obj.getJsonHeaders() != null) {
            json.put("jsonHeaders", obj.getJsonHeaders());
        }
        json.put("statusCode", obj.getStatusCode());
    }
}

