/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.dataobjects;

import com.google.common.base.Objects;
import io.knotx.dataobjects.KnotTask;
import io.knotx.dataobjects.KnotTaskStatus;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@DataObject(inheritConverter=true)
public class Fragment {
    private static final String RAW_FRAGMENT_ID = "_raw";
    private static final String FALLBACK_FRAGMENT_ID = "_fallback";
    private static final String KNOTS_KEY = "_KNOTS";
    private static final String CONTENT_KEY = "_CONTENT";
    private static final String CONTEXT_KEY = "_CONTEXT";
    private static final String FALLBACK_KEY = "_FALLBACK";
    private static final String ATTRUBUTES_KEY = "_ATTRIBUTES";
    private final List<KnotTask> knots;
    private final JsonObject context;
    private final JsonObject attributes;
    private String content;
    private String fallback;

    public Fragment(JsonObject fragment) {
        JsonArray knotsArray = fragment.getJsonArray(KNOTS_KEY);
        this.knots = knotsArray.stream().map(entry -> new KnotTask((JsonObject)entry)).collect(Collectors.toList());
        this.content = fragment.getString(CONTENT_KEY);
        this.context = fragment.getJsonObject(CONTEXT_KEY, new JsonObject());
        this.fallback = fragment.getString(FALLBACK_KEY);
        this.attributes = fragment.getJsonObject(ATTRUBUTES_KEY, new JsonObject());
    }

    private Fragment(List<String> knots, String data, String fallback) {
        if (knots == null || knots.isEmpty() || StringUtils.isEmpty((CharSequence)data)) {
            throw new NoSuchElementException("Fragment is not valid [" + knots + "], [" + data + "].");
        }
        this.knots = knots.stream().map(KnotTask::new).collect(Collectors.toList());
        this.content = data;
        this.context = new JsonObject();
        this.attributes = new JsonObject();
        this.fallback = fallback;
    }

    public static Fragment raw(String data) {
        return new Fragment(Collections.singletonList(RAW_FRAGMENT_ID), data, null);
    }

    public static Fragment snippet(List<String> knots, String data, String fallback) {
        return new Fragment(knots, data, fallback);
    }

    public static Fragment snippet(List<String> knots, String data) {
        return Fragment.snippet(knots, data, null);
    }

    public static Fragment fallback(String data, String fallbackId) {
        return new Fragment(Collections.singletonList(FALLBACK_FRAGMENT_ID), data, null).setAttribute("fallback-id", fallbackId);
    }

    public static Fragment fallback(String data, String fallbackId, String strategy) {
        return Fragment.fallback(data, fallbackId).setAttribute("fallback-strategy", strategy);
    }

    public Optional<String> fallback() {
        return Optional.ofNullable(this.fallback);
    }

    public JsonObject toJson() {
        return new JsonObject().put(KNOTS_KEY, new JsonArray(this.knots.stream().map(KnotTask::toJson).collect(Collectors.toList()))).put(CONTENT_KEY, this.content).put(CONTEXT_KEY, this.context).put(FALLBACK_KEY, this.fallback).put(ATTRUBUTES_KEY, this.attributes);
    }

    public List<String> knots() {
        return this.knots.stream().map(KnotTask::getName).collect(Collectors.toList());
    }

    public List<KnotTask> knotRouting() {
        return this.knots;
    }

    public String content() {
        return this.content;
    }

    public Fragment content(String content) {
        this.content = content;
        return this;
    }

    public Fragment setAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public String getAttribute(String key) {
        return this.attributes.getString(key);
    }

    public JsonObject context() {
        return this.context;
    }

    public boolean isRaw() {
        return this.knots().contains(RAW_FRAGMENT_ID);
    }

    public boolean isFallback() {
        return this.knots().contains(FALLBACK_FRAGMENT_ID);
    }

    public boolean failed() {
        return this.knots.stream().anyMatch(k -> k.getStatus() == KnotTaskStatus.FAILURE);
    }

    public Fragment failure(String knot, Throwable t) {
        this.knots.stream().filter(k -> knot.equals(k.getName())).findFirst().get().setStatus(KnotTaskStatus.FAILURE).error(t.getClass().getSimpleName(), t.getMessage());
        return this;
    }

    public Fragment success(String knot) {
        this.knots.stream().filter(k -> knot.equals(k.getName())).findFirst().get().setStatus(KnotTaskStatus.SUCCESS);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Fragment)) {
            return false;
        }
        Fragment that = (Fragment)o;
        return Objects.equal(this.knots, that.knots) && Objects.equal((Object)this.content, (Object)that.content) && Objects.equal((Object)this.context, (Object)that.context) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal((Object)this.fallback, (Object)that.fallback);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.knots, this.content, this.context, this.attributes, this.fallback});
    }

    public String toString() {
        return this.toJson().toString();
    }
}

