/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.dataobjects;

import com.google.common.base.Objects;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject(inheritConverter=true)
public class KnotError {
    private static final String CODE_KEY = "_CODE";
    private static final String MESSAGE_KEY = "_MESSAGE";
    private String code;
    private Object message;

    public KnotError(String code, Object message) {
        this.code = code;
        this.message = message;
    }

    public KnotError(JsonObject x) {
        this(x.getString(CODE_KEY), x.getString(MESSAGE_KEY));
    }

    public JsonObject toJson() {
        return new JsonObject().put(CODE_KEY, this.code).put(MESSAGE_KEY, this.message);
    }

    public String getCode() {
        return this.code;
    }

    public Object getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnotError)) {
            return false;
        }
        KnotError that = (KnotError)o;
        return Objects.equal((Object)this.code, (Object)that.code) && Objects.equal((Object)this.message, (Object)that.message);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.code, this.message});
    }
}

