/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.dataobjects;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import io.knotx.dataobjects.KnotError;
import io.knotx.dataobjects.KnotTaskStatus;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;

@DataObject(inheritConverter=true)
public class KnotTask {
    private final String name;
    private KnotTaskStatus status = KnotTaskStatus.UNPROCESSED;
    private List<KnotError> errors = Lists.newArrayList();
    private static final String NAME_KEY = "_NAME";
    private static final String STATUS_KEY = "_STATUS";
    private static final String ERRORS_KEY = "_ERRORS";

    public KnotTask(String name) {
        this.name = name;
    }

    public KnotTask(JsonObject knot) {
        this.name = knot.getString(NAME_KEY);
        this.status = KnotTaskStatus.valueOf(knot.getString(STATUS_KEY));
        JsonArray jsonErrors = knot.getJsonArray(ERRORS_KEY);
        this.errors = Lists.newArrayList();
        for (Object error : jsonErrors) {
            this.errors.add(new KnotError((JsonObject)error));
        }
    }

    public JsonObject toJson() {
        JsonArray errorsArray = new JsonArray();
        this.errors.stream().map(e -> errorsArray.add(e.toJson()));
        return new JsonObject().put(NAME_KEY, this.name).put(STATUS_KEY, this.status.name()).put(ERRORS_KEY, errorsArray);
    }

    public String getName() {
        return this.name;
    }

    public KnotTaskStatus getStatus() {
        return this.status;
    }

    public List<KnotError> getErrors() {
        return this.errors;
    }

    public KnotTask error(String code, Object message) {
        this.errors.add(new KnotError(code, message));
        return this;
    }

    public KnotTask setStatus(KnotTaskStatus status) {
        this.status = status;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnotTask)) {
            return false;
        }
        KnotTask that = (KnotTask)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.status, this.errors});
    }
}

