/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments;

import io.knotx.dataobjects.Fragment;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public final class FragmentContentExtractor {
    private FragmentContentExtractor() {
    }

    public static String unwrapContent(Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        return fragment.isRaw() ? fragment.content() : FragmentContentExtractor.extractSnippetContent(fragment.content());
    }

    public static Element unwrapContent(String content) {
        Document result = null;
        if (content != null) {
            String unwrapped = FragmentContentExtractor.extractSnippetContent(content);
            result = Jsoup.parse((String)unwrapped, (String)"UTF-8", (Parser)Parser.xmlParser());
        }
        return result;
    }

    public static Element unwrapFragmentContent(Fragment fragment) {
        return fragment == null ? null : FragmentContentExtractor.unwrapContent(fragment.content());
    }

    public static String abbreviate(String content) {
        return StringUtils.abbreviate((String)content.replaceAll("[\n\r\t]", ""), (int)256);
    }

    private static String extractSnippetContent(String content) {
        return content.substring(content.indexOf(62) + 1, content.lastIndexOf(60));
    }
}

