/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments;

import io.knotx.options.SnippetOptions;
import java.util.regex.Pattern;

public class SnippetPatterns {
    private static final String ANY_SNIPPET_PATTERN = "(?is).*<%s\\s+%sknots.*";
    private static final String SNIPPET_PATTERN = "<%s\\s+%sknots\\s*=\\s*\"([A-Za-z0-9-,]+)\"[^>]*>.+?</%s>";
    private static final String SNIPPET_WITH_FALLBACK_PATTERN = "<%s\\s+%sknots\\s*=\\s*\"([A-Za-z0-9-,]+)\"[^>]*%sfallback\\s*=\\s*\"([^\"]*)\"[^>]*>.+?</%s>";
    private static final String FALLBACK_PATTERN = "<%s\\s+%sfallback-id\\s*=\\s*\"([A-Za-z0-9-_,]+)\"[^>]*>.+?</%s>";
    private static final String FALLBACK_WITH_STRATEGY_PATTERN = "<%s\\s+%sfallback-id\\s*=\\s*\"([A-Za-z0-9-_,]+)\"[^>]*%sfallback-strategy\\s*=\\s*\"([^\"]*)\"[^>]*>.+?</%s>";
    private final Pattern anySnippetPattern;
    private final Pattern snippetPattern;
    private final Pattern snippetWithFallbackPattern;
    private final Pattern fallbackPattern;
    private final Pattern fallbackWithStrategyPattern;

    public SnippetPatterns(SnippetOptions snippetOptions) {
        this.anySnippetPattern = Pattern.compile(String.format(ANY_SNIPPET_PATTERN, snippetOptions.getTagName(), snippetOptions.getParamsPrefix()), 32);
        this.snippetPattern = Pattern.compile(String.format(SNIPPET_PATTERN, snippetOptions.getTagName(), snippetOptions.getParamsPrefix(), snippetOptions.getTagName()), 32);
        this.snippetWithFallbackPattern = Pattern.compile(String.format(SNIPPET_WITH_FALLBACK_PATTERN, snippetOptions.getTagName(), snippetOptions.getParamsPrefix(), snippetOptions.getParamsPrefix(), snippetOptions.getTagName()), 32);
        this.fallbackPattern = Pattern.compile(String.format(FALLBACK_PATTERN, snippetOptions.getFallbackTagName(), snippetOptions.getParamsPrefix(), snippetOptions.getFallbackTagName()), 32);
        this.fallbackWithStrategyPattern = Pattern.compile(String.format(FALLBACK_WITH_STRATEGY_PATTERN, snippetOptions.getFallbackTagName(), snippetOptions.getParamsPrefix(), snippetOptions.getParamsPrefix(), snippetOptions.getFallbackTagName()), 32);
    }

    public Pattern getAnySnippetPattern() {
        return this.anySnippetPattern;
    }

    public Pattern getSnippetPattern() {
        return this.snippetPattern;
    }

    public Pattern getSnippetWithFallbackPattern() {
        return this.snippetWithFallbackPattern;
    }

    public Pattern getFallbackPattern() {
        return this.fallbackPattern;
    }

    public Pattern getFallbackWithStrategyPattern() {
        return this.fallbackWithStrategyPattern;
    }
}

