/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.http;

import com.google.common.collect.ImmutableSet;
import io.vertx.reactivex.core.MultiMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MultiMapCollector<T>
implements Collector<T, MultiMap, MultiMap> {
    private final Function<T, String> keyGetter;
    private final Function<T, List<String>> value;

    private MultiMapCollector(Function<T, String> keyGetter, Function<T, List<String>> value) {
        this.keyGetter = keyGetter;
        this.value = value;
    }

    public static <T> MultiMapCollector<T> toMultiMap(Function<T, String> keyGetter, Function<T, List<String>> valueGetter) {
        return new MultiMapCollector<T>(keyGetter, valueGetter);
    }

    @Override
    public Supplier<MultiMap> supplier() {
        return MultiMap::caseInsensitiveMultiMap;
    }

    @Override
    public BiConsumer<MultiMap, T> accumulator() {
        return (multiMap, t) -> this.value.apply(t).forEach(v -> multiMap.add(this.keyGetter.apply(t), v));
    }

    @Override
    public BinaryOperator<MultiMap> combiner() {
        return (map1, map2) -> {
            map1.addAll(map2);
            return map1;
        };
    }

    @Override
    public Function<MultiMap, MultiMap> finisher() {
        return map -> map;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return ImmutableSet.of((Object)((Object)Collector.Characteristics.IDENTITY_FINISH));
    }
}

