/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.knot;

import com.google.common.collect.Sets;
import io.knotx.dataobjects.Fragment;
import io.knotx.dataobjects.KnotContext;
import io.knotx.proxy.KnotProxy;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractKnotProxy
implements KnotProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKnotProxy.class);
    protected static final String DEFAULT_TRANSITION = "next";

    @Override
    public void process(KnotContext knotContext, Handler<AsyncResult<KnotContext>> result) {
        if (this.shouldProcess(knotContext)) {
            this.processRequest(knotContext).subscribe(ctx -> result.handle((Object)Future.succeededFuture((Object)ctx)), error -> {
                LOGGER.error((Object)"Error happened during Knot Context processing", error);
                result.handle((Object)Future.succeededFuture((Object)this.processError(knotContext, (Throwable)error)));
            });
        } else {
            knotContext.setTransition(StringUtils.isBlank((CharSequence)knotContext.getTransition()) ? DEFAULT_TRANSITION : knotContext.getTransition());
            result.handle((Object)Future.succeededFuture((Object)knotContext));
        }
    }

    protected abstract Single<KnotContext> processRequest(KnotContext var1);

    protected boolean shouldProcess(Fragment fragment) {
        return !fragment.failed() && this.shouldProcess(Sets.newHashSet(fragment.knots()));
    }

    protected abstract boolean shouldProcess(Set<String> var1);

    protected abstract KnotContext processError(KnotContext var1, Throwable var2);

    private boolean shouldProcess(KnotContext context) {
        Set<String> knots = Optional.ofNullable(context).map(KnotContext::getFragments).map(this::getKnotSet).orElse(Collections.emptySet());
        return this.shouldProcess(knots);
    }

    private Set<String> getKnotSet(List<Fragment> fragments) {
        return fragments.stream().map(Fragment::knots).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

