/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher;

import com.google.common.collect.Lists;
import io.knotx.Version;
import io.knotx.launcher.BadKnotxConfigurationException;
import io.knotx.launcher.ModuleDescriptor;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.config.ConfigRetriever;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.Vertx;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class KnotxStarterVerticle
extends AbstractVerticle {
    private static final String MODULES_ARRAY = "modules";
    private static final String CONFIG_OVERRIDE = "config";
    private static final String MODULE_OPTIONS = "options";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxStarterVerticle.class);
    private static final String FILE_STORE = "file";
    private List<ModuleDescriptor> deployedModules;
    private ConfigRetriever configRetriever;

    public void start(Future<Void> startFuture) {
        this.printLogo();
        try {
            JsonObject configOptions = this.getConfigRetrieverOptions(this.config());
            this.configRetriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions(configOptions));
            this.configRetriever.listen(conf -> {
                if (!this.deployedModules.isEmpty()) {
                    LOGGER.warn((Object)"Configuration changed - Re-deploying Knot.x");
                    Observable.fromIterable(this.deployedModules).flatMap(item -> this.vertx.rxUndeploy(item.getDeploymentId()).toObservable()).collect(Lists::newArrayList, ArrayList::add).subscribe(success -> {
                        LOGGER.warn((Object)"Knot.x STOPPED.");
                        this.deployVerticles(conf.getNewConfiguration(), null);
                    }, error -> {
                        LOGGER.error((Object)"Unable to undeploy verticles", error);
                        startFuture.fail(error);
                    });
                }
            });
            this.configRetriever.getConfig(ar -> {
                if (ar.succeeded()) {
                    JsonObject configuration = (JsonObject)ar.result();
                    this.deployVerticles(configuration, startFuture);
                } else {
                    LOGGER.fatal((Object)"Unable to start Knot.x", ar.cause());
                    startFuture.fail(ar.cause());
                }
            });
        }
        catch (BadKnotxConfigurationException ex) {
            startFuture.fail((Throwable)((Object)ex));
        }
    }

    private JsonObject getConfigRetrieverOptions(JsonObject config) {
        JsonObject configOptions = null;
        if (this.config().getJsonObject("configRetrieverOptions") == null) {
            throw new BadKnotxConfigurationException("Missing 'configRetrieverOptions' in the main config file");
        }
        configOptions = config.getJsonObject("configRetrieverOptions");
        configOptions.getJsonArray("stores").stream().map(item -> (JsonObject)item).forEach(store -> {
            if (FILE_STORE.equals(store.getString("type"))) {
                store.getJsonObject(CONFIG_OVERRIDE).put("path", this.resolveConfigPath(store.getJsonObject(CONFIG_OVERRIDE).getString("path")));
            }
        });
        return configOptions;
    }

    private String resolveConfigPath(String path) {
        String resolvedPath = path;
        if (path.startsWith("${KNOTX_HOME}")) {
            String home = System.getProperty("knotx.home");
            if (home == null) {
                home = System.getenv("KNOTX_HOME");
                if (home == null) {
                    throw new BadKnotxConfigurationException("Unable to resolve ${KNOTX_HOME} for " + path + ". System property 'knotx.home', or environment variable 'KNOTX_HOME' are not set");
                }
            } else {
                resolvedPath = path.replace("${KNOTX_HOME}", home);
            }
        }
        return resolvedPath;
    }

    private void deployVerticles(JsonObject config, Future<Void> completion) {
        LOGGER.info((Object)"STARTING Knot.x {} @ {}", new Object[]{Version.getVersion(), Version.getBuildTime()});
        Observable.fromIterable((Iterable)config.getJsonArray(MODULES_ARRAY)).cast(String.class).map(ModuleDescriptor::parse).flatMap(item -> this.deployVerticle(config, (ModuleDescriptor)item)).reduce(new ArrayList(), (accumulator, item) -> {
            accumulator.add(item);
            return accumulator;
        }).subscribe(deployments -> {
            this.deployedModules = Lists.newArrayList((Iterable)deployments);
            LOGGER.info((Object)"Knot.x STARTED {}", new Object[]{this.buildMessage()});
            if (completion != null) {
                completion.complete();
            }
        }, error -> {
            LOGGER.error((Object)"Verticle could not be deployed", error);
            if (completion != null) {
                completion.fail(error);
            }
        });
    }

    private Observable<ModuleDescriptor> deployVerticle(JsonObject config, ModuleDescriptor module) {
        return this.vertx.rxDeployVerticle(module.getName(), this.getModuleOptions(config, module.getAlias())).map(deployId -> new ModuleDescriptor(module).setDeploymentId((String)deployId).setState(ModuleDescriptor.DeploymentState.SUCCESS)).doOnError(error -> LOGGER.error((Object)"Can't deploy {}: {}", new Object[]{module.toDescriptorLine(), error})).onErrorResumeNext(err -> Single.just((Object)new ModuleDescriptor(module).setState(ModuleDescriptor.DeploymentState.FAILED))).toObservable();
    }

    private DeploymentOptions getModuleOptions(JsonObject config, String module) {
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        if (config.containsKey(CONFIG_OVERRIDE)) {
            if (config.getJsonObject(CONFIG_OVERRIDE).containsKey(module)) {
                JsonObject moduleConfig = config.getJsonObject(CONFIG_OVERRIDE).getJsonObject(module);
                if (moduleConfig.containsKey(MODULE_OPTIONS)) {
                    deploymentOptions.fromJson(moduleConfig.getJsonObject(MODULE_OPTIONS));
                } else {
                    LOGGER.warn((Object)"Module '{}' has config, but missing 'options' object. Default configuration is to be used", new Object[]{module});
                }
            } else {
                LOGGER.warn((Object)"Module '{}' if not configured in the config file. Used default configuration", new Object[]{module});
            }
        }
        return deploymentOptions;
    }

    private String buildMessage() {
        return System.lineSeparator() + this.deployedModules.stream().map(item -> String.format("\t\t%s %s [%s]", new Object[]{item.getState(), item.toDescriptorLine(), item.getDeploymentId()})).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator();
    }

    private void printLogo() {
        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        System.out.println("@@                                  ,,,,,,,,,                                 @@");
        System.out.println("@@                                *,,,,,,,,,,,*                               @@");
        System.out.println("@@                              @@&,,,,,,,,,,,,,*                             @@");
        System.out.println("@@                            @@@@@@,,,,,,,,,,,,,,*                           @@");
        System.out.println("@@                          @@@@@@@@@,,,,,,,,,,,,,,,*                         @@");
        System.out.println("@@                        @@@@@@@@@@@@/,,,,,,,,,,,,,,,*                       @@");
        System.out.println("@@                      @@@@@@@@@@@@@@@#,,,,,,,,,,,,,,,,*                     @@");
        System.out.println("@@                    &@@@@@@@@@@@@@@@@@&,,,,,,,,,,,,,,*@@#                   @@");
        System.out.println("@@                  @@&,@@@@@@@@@@@@@@@@@@,,,,,,,,,,,,(@@@@@#                 @@");
        System.out.println("@@                @@@@&,,%@@@@@@@@@@@@@@@@@*,,,,,,,,,%@@@@@@@@#               @@");
        System.out.println("@@              @@@@@@&,,,*@@@@@@@@@@@@@@@@@(,,,,,,,@@@@@@@@@@@@#             @@");
        System.out.println("@@            @@@@@@@@&,,,,,@@@@@@@@@@@@@@@@@&,,,,,@@@@@@@@@@@@@@@#           @@");
        System.out.println("@@          @@@@@@@@@@&,,,,,,%@@@@@@@@@@@@@@@@@,,/@@@@@@@@@@@@@@@@@,*         @@");
        System.out.println("@@        @@@@@@@@@@@@&,,,,,,,*@@@@@@@@@@@@@@@@@%@@@@@@@@@@@@@@@@#,,,,*       @@");
        System.out.println("@@      ,@@@@@@@@@@@@@&,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*,,,,,,,*     @@");
        System.out.println("@@    ,,,@@@@@@@@@@@@@&,,,,,,,,,,#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@,,,,,,,,,,,*   @@");
        System.out.println("@@  *,,,,#@@@@@@@@@@@@&,,,,,,,,,,,*@@@@@@@@@@@@@@@@@@@@@@@@@@(,,,,,,,,,,,,,,* @@");
        System.out.println("@@ ,,,,,,*@@@@@@@@@@@@&,,,,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@@@@,,,,,,,,,,,,,,,,,*@@");
        System.out.println("@@,,,,,,,,@@@@@@@@@@@@&,,,,,,,,,,,,,,(@@@@@@@@@@@@@@@@@@@@&,,,,,,,,,,,,,,,,,,,@@");
        System.out.println("@@/,,,,,,,&@@@@@@@@@@@&,,,,,,,,,,,,,,,*@@@@@@@@@@@@@@@@@@@/,,,,,,,,,,,,,,,,,,,@@");
        System.out.println("@@ *,,,,,,(@@@@@@@@@@@&,,,,,,,,,,,,,,#@@@@@@@@@@@@@@@@@@@@@&,,,,,,,,,,,,,,,,, @@");
        System.out.println("@@   ,,,,,*@@@@@@@@@@@&,,,,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@@@@@,,,,,,,,,,,,,,*  @@");
        System.out.println("@@     ,,,,@@@@@@@@@@@&,,,,,,,,,,,*@@@@@@@@@@@@@@@@@@@@@@@@@@@(,,,,,,,,,,*    @@");
        System.out.println("@@       ,,,,,,,,,,,,,,,,,,,,,,,,%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@,,,,,,,*      @@");
        System.out.println("@@         ,,&@@@@@@@%,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*,,,*        @@");
        System.out.println("@@           @@@@@@@@@@*,,,,,,/@@@@@@@@@@@@@@@@@*@@@@@@@@@@@@@@@@@#*          @@");
        System.out.println("@@             @@@@@@@@@,,,,,&@@@@@@@@@@@@@@@@#,,,@@@@@@@@@@@@@@@@            @@");
        System.out.println("@@               @@@@@@@,,,,@@@@@@@@@@@@@@@@@*,,,,,%@@@@@@@@@@@@              @@");
        System.out.println("@@                 @@@@*,,(@@@@@@@@@@@@@@@@@,,,,,,,,/@@@@@@@@@                @@");
        System.out.println("@@                   @,,,&@@@@@@@@@@@@@@@@&,,,,,,,,,,,@@@@@@                  @@");
        System.out.println("@@                     *@@@@@@@@@@@@@@@@@(,,,,,,,,,,,,,&@@                    @@");
        System.out.println("@@                       @@@@@@@@@@@@@@@*,,,,,,,,,,,,,,*                      @@");
        System.out.println("@@                         @@@@@@@@@@@@,,,,,,,,,,,,,,*                        @@");
        System.out.println("@@                           @@@@@@@@%,,,,,,,,,,,,,*                          @@");
        System.out.println("@@                            @@@@@/,,,,,,,,,,,,*                             @@");
        System.out.println("@@                               @@,,,,,,,,,,,,*                              @@");
        System.out.println("@@                                 *,,,,,,,,,*                                @@");
        System.out.println("@@                                    ,,,*/                                   @@");
        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        System.out.println();
    }
}

