/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher;

public class ModuleDescriptor {
    public static final String MODULE_DEFAULT_PREFIX = "java:";
    public static final char MODULE_ALIAS_SEPARATOR = '=';
    private String alias;
    private String name;
    private String deploymentId;
    private DeploymentState state = DeploymentState.UNKNOWN;

    private ModuleDescriptor() {
    }

    public ModuleDescriptor(ModuleDescriptor other) {
        this.alias = other.alias;
        this.name = other.name;
        this.deploymentId = other.deploymentId;
        this.state = other.state;
    }

    public static ModuleDescriptor parse(String line) {
        ModuleDescriptor descriptor = new ModuleDescriptor();
        int separatorIdx = line.indexOf(61);
        if (separatorIdx == -1) {
            throw new IllegalArgumentException("Module '" + line + "'should have form of <alias>" + '=' + "<service>, e.g.: myAlias" + '=' + "com.acme.VerticleClassName");
        }
        descriptor.alias = line.substring(0, separatorIdx);
        String name = line.substring(separatorIdx + 1);
        descriptor.name = name.indexOf(58) != -1 ? name : MODULE_DEFAULT_PREFIX + name;
        return descriptor;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public ModuleDescriptor setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public ModuleDescriptor setState(DeploymentState state) {
        this.state = state;
        return this;
    }

    public DeploymentState getState() {
        return this.state;
    }

    public String toDescriptorLine() {
        return this.alias + '=' + this.name;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.alias).append(" [").append(this.name).append("]");
        if (this.deploymentId != null) {
            result.append(" [").append(this.deploymentId).append("]");
        }
        return result.toString();
    }

    public static enum DeploymentState {
        UNKNOWN("Unknown state"),
        SUCCESS("Deployed"),
        FAILED("Failed to deploy");

        private final String message;

        private DeploymentState(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

