/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigResolver;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.vertx.config.impl.spi.PropertiesConfigProcessor;
import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfProcessor
implements ConfigProcessor {
    public String name() {
        return "conf";
    }

    public void process(Vertx vertx, JsonObject configuration, Buffer input, Handler<AsyncResult<JsonObject>> handler) {
        vertx.executeBlocking(future -> {
            StringReader reader = new StringReader(input.toString("UTF-8"));
            try {
                Config conf = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)ConfigParseOptions.defaults().appendIncluder((ConfigIncluder)new KnotxConfIncluder(configuration)));
                conf = conf.resolve(ConfigResolveOptions.defaults().appendResolver((ConfigResolver)new SysPropResolver()));
                String output = conf.root().render(ConfigRenderOptions.concise().setJson(true).setComments(false).setFormatted(false));
                JsonObject json = new JsonObject(output);
                future.complete((Object)json);
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
            finally {
                PropertiesConfigProcessor.closeQuietly((Closeable)reader);
            }
        }, handler);
    }

    private class KnotxConfIncluder
    implements ConfigIncluder {
        private String configSearchFolder;

        public KnotxConfIncluder(JsonObject configuration) {
            this.configSearchFolder = Optional.ofNullable(configuration.getString("path")).map(path -> path.contains("/") ? path.substring(0, path.lastIndexOf("/")) : "").orElse(System.getProperty("knotx.home") + "/conf");
        }

        public ConfigIncluder withFallback(ConfigIncluder fallback) {
            return this;
        }

        public ConfigObject include(ConfigIncludeContext context, String what) {
            File file = StringUtils.isBlank((CharSequence)this.configSearchFolder) ? new File(what) : new File(this.configSearchFolder, what);
            return ConfigFactory.parseFile((File)file, (ConfigParseOptions)context.parseOptions()).root();
        }
    }

    private class SysPropResolver
    implements ConfigResolver {
        private final Properties sysProps = System.getProperties();

        private SysPropResolver() {
        }

        public ConfigValue lookup(String path) {
            String value = this.sysProps.getProperty(path);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (NumberUtils.isCreatable((String)value)) {
                    return ConfigValueFactory.fromAnyRef((Object)NumberUtils.toInt((String)value));
                }
                if (Boolean.TRUE.toString().equalsIgnoreCase(value) || Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                    return ConfigValueFactory.fromAnyRef((Object)BooleanUtils.toBoolean((String)value));
                }
                return ConfigValueFactory.fromAnyRef((Object)value);
            }
            return null;
        }

        public ConfigResolver withFallback(ConfigResolver fallback) {
            return fallback;
        }
    }
}

