/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.options;

import com.google.common.collect.Lists;
import io.knotx.options.FallbackMetadata;
import io.knotx.options.SnippetOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

@DataObject(generateConverter=true, publicConverter=false)
public class SnippetOptions {
    private static final String DEFAULT_TAG_NAME = "script";
    private static final String DEFAULT_FALLBACK_TAG_NAME = "knotx:fallback";
    private static final String DEFAULT_PARAMS_PREFIX = "data-knotx-";
    private String tagName;
    private String paramsPrefix;
    private String fallbackTagName;
    private String defaultFallback;
    private List<FallbackMetadata> fallbacks;

    public SnippetOptions() {
        this.init();
        this.configureDefaultFallback();
    }

    public SnippetOptions(SnippetOptions other) {
        this.tagName = other.tagName;
        this.paramsPrefix = other.paramsPrefix;
        this.fallbackTagName = other.fallbackTagName;
        this.defaultFallback = other.defaultFallback;
        this.fallbacks = new ArrayList<FallbackMetadata>(other.fallbacks);
    }

    public SnippetOptions(JsonObject json) {
        this.init();
        SnippetOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.configureDefaultFallback();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        SnippetOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.tagName = DEFAULT_TAG_NAME;
        this.paramsPrefix = DEFAULT_PARAMS_PREFIX;
        this.fallbackTagName = DEFAULT_FALLBACK_TAG_NAME;
    }

    private void configureDefaultFallback() {
        if (CollectionUtils.isEmpty(this.fallbacks)) {
            this.fallbacks = Lists.newArrayList((Object[])new FallbackMetadata[]{new FallbackMetadata("BLANK", "")});
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getFallbackTagName() {
        return this.fallbackTagName;
    }

    public String getDefaultFallback() {
        return this.defaultFallback;
    }

    public SnippetOptions setDefaultFallback(String defaultFallback) {
        this.defaultFallback = defaultFallback;
        return this;
    }

    public SnippetOptions setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public SnippetOptions setFallbackTagName(String fallbackTagName) {
        this.fallbackTagName = fallbackTagName;
        return this;
    }

    public String getParamsPrefix() {
        return this.paramsPrefix;
    }

    public SnippetOptions setParamsPrefix(String paramsPrefix) {
        this.paramsPrefix = paramsPrefix == null ? "" : paramsPrefix;
        return this;
    }

    public List<FallbackMetadata> getFallbacks() {
        return this.fallbacks;
    }

    public SnippetOptions setFallbacks(List<FallbackMetadata> fallbacks) {
        this.fallbacks = fallbacks;
        return this;
    }
}

