/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.proxy;

import io.knotx.dataobjects.KnotContext;
import io.knotx.proxy.KnotProxy;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;

public class KnotProxyVertxEBProxy
implements KnotProxy {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public KnotProxyVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public KnotProxyVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void process(KnotContext knotContext, Handler<AsyncResult<KnotContext>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("knotContext", knotContext == null ? null : knotContext.toJson());
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "process");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() == null ? null : new KnotContext((JsonObject)((Message)res.result()).body()))));
            }
        });
    }
}

