/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.proxy;

import io.knotx.dataobjects.KnotContext;
import io.knotx.proxy.KnotProxy;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;

public class KnotProxyVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final KnotProxy service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;

    public KnotProxyVertxProxyHandler(Vertx vertx, KnotProxy service) {
        this(vertx, service, 300L);
    }

    public KnotProxyVertxProxyHandler(Vertx vertx, KnotProxy service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public KnotProxyVertxProxyHandler(Vertx vertx, KnotProxy service, boolean topLevel, long timeoutSeconds) {
        this.vertx = vertx;
        this.service = service;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "process": {
                    this.service.process(json.getJsonObject("knotContext") == null ? null : new KnotContext(json.getJsonObject("knotContext")), (Handler<AsyncResult<KnotContext>>)((Handler)res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((KnotContext)res.result()).toJson());
                        }
                    }));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            msg.reply((Object)new ServiceException(500, t.getMessage()));
            throw t;
        }
    }
}

