/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.proxy;

import io.knotx.dataobjects.ClientRequest;
import io.knotx.dataobjects.ClientResponse;
import io.knotx.proxy.RepositoryConnectorProxy;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;

public class RepositoryConnectorProxyVertxEBProxy
implements RepositoryConnectorProxy {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public RepositoryConnectorProxyVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public RepositoryConnectorProxyVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void process(ClientRequest request, Handler<AsyncResult<ClientResponse>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("request", request == null ? null : request.toJson());
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "process");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() == null ? null : new ClientResponse((JsonObject)((Message)res.result()).body()))));
            }
        });
    }
}

