/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.repository.fs;

import io.knotx.dataobjects.ClientRequest;
import io.knotx.dataobjects.ClientResponse;
import io.knotx.proxy.RepositoryConnectorProxy;
import io.knotx.repository.fs.FilesystemRepositoryOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.MultiMap;
import java.nio.file.NoSuchFileException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class FilesystemRepositoryConnectorProxyImpl
implements RepositoryConnectorProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemRepositoryConnectorProxyImpl.class);
    private static final String ERROR_MESSAGE = "Unable to get template from the repository";
    private final FilesystemRepositoryOptions config;
    private final io.vertx.reactivex.core.file.FileSystem fileSystem;

    public FilesystemRepositoryConnectorProxyImpl(Vertx vertx, FilesystemRepositoryOptions configuration) {
        this.fileSystem = io.vertx.reactivex.core.file.FileSystem.newInstance((FileSystem)vertx.fileSystem());
        this.config = configuration;
    }

    @Override
    public void process(ClientRequest request, Handler<AsyncResult<ClientResponse>> result) {
        String localFilePath = this.config.getCatalogue() + StringUtils.stripStart((String)request.getPath(), (String)"/");
        Optional<String> contentType = Optional.ofNullable(MimeMapping.getMimeTypeForFilename((String)localFilePath));
        LOGGER.debug((Object)"Fetching file `{}` from local repository.", new Object[]{localFilePath});
        this.fileSystem.rxReadFile(localFilePath).map(buffer -> new ClientResponse().setStatusCode(HttpResponseStatus.OK.code()).setHeaders(this.headers(contentType)).setBody(buffer.getDelegate())).subscribe(response -> result.handle((Object)Future.succeededFuture((Object)response)), error -> {
            LOGGER.error((Object)ERROR_MESSAGE, error);
            result.handle((Object)Future.succeededFuture((Object)this.processError((Throwable)error)));
        });
    }

    private MultiMap headers(Optional<String> contentType) {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        contentType.ifPresent(s -> headers.add("Content-Type", s));
        return headers;
    }

    private ClientResponse processError(Throwable error) {
        HttpResponseStatus statusCode = error.getCause().getClass().equals(NoSuchFileException.class) ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.INTERNAL_SERVER_ERROR;
        return new ClientResponse().setStatusCode(statusCode.code());
    }
}

