/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.repository.http;

import io.knotx.dataobjects.ClientRequest;
import io.knotx.dataobjects.ClientResponse;
import io.knotx.http.AllowedHeadersFilter;
import io.knotx.http.MultiMapCollector;
import io.knotx.proxy.RepositoryConnectorProxy;
import io.knotx.repository.http.HttpRepositoryOptions;
import io.knotx.util.DataObjectsUtil;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.core.http.HttpClientResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class HttpRepositoryConnectorProxyImpl
implements RepositoryConnectorProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRepositoryConnectorProxyImpl.class);
    private static final String ERROR_MESSAGE = "Unable to get template from the repository";
    private final HttpRepositoryOptions configuration;
    private final HttpClient httpClient;

    public HttpRepositoryConnectorProxyImpl(Vertx vertx, HttpRepositoryOptions configuration) {
        this.configuration = configuration;
        this.httpClient = HttpClient.newInstance((io.vertx.core.http.HttpClient)vertx.createHttpClient(configuration.getClientOptions()));
    }

    @Override
    public void process(ClientRequest request, Handler<AsyncResult<ClientResponse>> result) {
        MultiMap requestHeaders = this.buildHeaders(this.configuration.getClientDestination().getHostHeader(), request.getHeaders());
        RequestOptions httpRequestData = this.buildRequestData(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"GET HTTP Repository: {}  with headers [{}]", new Object[]{this.getUrl(httpRequestData), DataObjectsUtil.toString(requestHeaders)});
        }
        this.get(this.httpClient, httpRequestData, requestHeaders).doOnNext(this::traceHttpResponse).flatMap(response -> this.processResponse((HttpClientResponse)response, httpRequestData)).subscribe(response -> result.handle((Object)Future.succeededFuture((Object)response)), error -> {
            LOGGER.error((Object)ERROR_MESSAGE, error);
            result.handle((Object)Future.succeededFuture((Object)this.toInternalError()));
        });
    }

    private String getUrl(RequestOptions httpRequestData) {
        return String.format("%s://%s:%d%s ", httpRequestData.isSsl() != false ? "https" : "http", httpRequestData.getHost(), httpRequestData.getPort(), httpRequestData.getURI());
    }

    private RequestOptions buildRequestData(ClientRequest request) {
        return new RequestOptions().setSsl(Boolean.valueOf(this.configuration.getClientDestination().getScheme().equals("https"))).setURI(this.buildRepoUri(request)).setPort(this.configuration.getClientDestination().getPort()).setHost(this.configuration.getClientDestination().getDomain());
    }

    private Observable<HttpClientResponse> get(HttpClient client, RequestOptions requestOptions, MultiMap headers) {
        return Observable.unsafeCreate(subscriber -> {
            HttpClientRequest req = client.get(requestOptions);
            req.headers().addAll(headers);
            if (headers.get(HttpHeaderNames.HOST.toString()) != null) {
                req.setHost(headers.get(HttpHeaderNames.HOST.toString()));
            }
            Observable resp = req.toObservable();
            resp.subscribe(subscriber);
            req.end();
        });
    }

    private String buildRepoUri(ClientRequest repoRequest) {
        StringBuilder uri = new StringBuilder(repoRequest.getPath());
        MultiMap params = repoRequest.getParams();
        if (params != null && params.names() != null && !params.names().isEmpty()) {
            uri.append("?").append(params.names().stream().map(name -> new StringBuilder(this.encode((String)name)).append("=").append(this.encode(params.get(name)))).collect(Collectors.joining("&")));
        }
        return uri.toString();
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.fatal((Object)"Unexpected Exception - Unsupported encoding UTF-8", (Throwable)ex);
            throw new UnsupportedCharsetException("UTF-8");
        }
    }

    private Observable<ClientResponse> processResponse(HttpClientResponse response, RequestOptions httpRequestData) {
        return Observable.just((Object)Buffer.buffer()).mergeWith((ObservableSource)response.toObservable()).reduce(Buffer::appendBuffer).toObservable().map(buffer -> this.toResponse((Buffer)buffer, response, httpRequestData));
    }

    private ClientResponse toResponse(Buffer buffer, HttpClientResponse httpResponse, RequestOptions httpRequestData) {
        int statusCode = httpResponse.statusCode();
        if (HttpStatusClass.SUCCESS.contains(statusCode)) {
            LOGGER.debug((Object)"Repository 2xx response: {}, Headers[{}]", new Object[]{statusCode, DataObjectsUtil.toString(httpResponse.headers())});
        } else if (HttpStatusClass.REDIRECTION.contains(statusCode)) {
            LOGGER.info((Object)"Repository 3xx response: {}, Headers[{}]", new Object[]{statusCode, DataObjectsUtil.toString(httpResponse.headers())});
        } else if (HttpStatusClass.CLIENT_ERROR.contains(statusCode)) {
            LOGGER.warn((Object)"Repository client error 4xx. Request URL: {}, response: {}, Headers[{}]", new Object[]{this.getUrl(httpRequestData), statusCode, DataObjectsUtil.toString(httpResponse.headers())});
        } else if (HttpStatusClass.SERVER_ERROR.contains(statusCode)) {
            LOGGER.error((Object)"Repository server error 5xx. Request URL: {},  response: {}, Headers[{}]", new Object[]{this.getUrl(httpRequestData), statusCode, DataObjectsUtil.toString(httpResponse.headers())});
        } else {
            LOGGER.warn((Object)"Other response: {}, Headers[{}]", new Object[]{statusCode, DataObjectsUtil.toString(httpResponse.headers())});
        }
        return new ClientResponse().setStatusCode(statusCode).setHeaders(httpResponse.headers()).setBody(buffer.getDelegate());
    }

    private ClientResponse toInternalError() {
        return new ClientResponse().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
    }

    private MultiMap buildHeaders(String hostHeader, MultiMap headers) {
        MultiMap result = this.filteredHeaders(headers);
        if (this.configuration.getCustomHttpHeader() != null) {
            result.set(this.configuration.getCustomHttpHeader().getName(), this.configuration.getCustomHttpHeader().getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)hostHeader)) {
            result.set(HttpHeaderNames.HOST.toString(), hostHeader);
        }
        return result;
    }

    private MultiMap filteredHeaders(MultiMap headers) {
        return (MultiMap)headers.names().stream().filter(AllowedHeadersFilter.create(this.configuration.getAllowedRequestHeadersPatterns())).collect(MultiMapCollector.toMultiMap(o -> o, arg_0 -> ((MultiMap)headers).getAll(arg_0)));
    }

    private void traceHttpResponse(HttpClientResponse response) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Got response from remote repository status [{}]", new Object[]{response.statusCode()});
        }
    }
}

