/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.repository.http;

import io.knotx.configuration.CustomHttpHeader;
import io.knotx.repository.http.ClientDestination;
import io.knotx.repository.http.HttpRepositoryOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@DataObject(generateConverter=true, publicConverter=false)
public class HttpRepositoryOptions {
    public static final String DEFAULT_ADDRESS = "knotx.core.repository.http";
    private String address;
    private HttpClientOptions clientOptions;
    private ClientDestination clientDestination;
    private Set<String> allowedRequestHeaders;
    private List<Pattern> allowedRequestHeaderPatterns;
    private CustomHttpHeader customHttpHeader;

    public HttpRepositoryOptions() {
        this.init();
    }

    public HttpRepositoryOptions(HttpRepositoryOptions other) {
        this.address = other.address;
        this.clientOptions = new HttpClientOptions(other.clientOptions);
        this.clientDestination = null;
        this.allowedRequestHeaders = new HashSet<String>(other.allowedRequestHeaders);
        this.allowedRequestHeaderPatterns = new ArrayList<Pattern>(other.allowedRequestHeaderPatterns);
        this.customHttpHeader = new CustomHttpHeader(other.customHttpHeader);
    }

    public HttpRepositoryOptions(JsonObject json) {
        this.init();
        HttpRepositoryOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        if (this.allowedRequestHeaders != null) {
            this.allowedRequestHeaderPatterns = this.allowedRequestHeaders.stream().map(expr -> Pattern.compile(expr, 2)).collect(Collectors.toList());
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        HttpRepositoryOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.address = DEFAULT_ADDRESS;
        this.clientOptions = new HttpClientOptions();
        this.clientDestination = new ClientDestination();
        this.allowedRequestHeaders = new HashSet<String>();
        this.customHttpHeader = null;
    }

    public String getAddress() {
        return this.address;
    }

    public HttpRepositoryOptions setAddress(String address) {
        this.address = address;
        return this;
    }

    public HttpClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public HttpRepositoryOptions setClientOptions(HttpClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ClientDestination getClientDestination() {
        return this.clientDestination;
    }

    public HttpRepositoryOptions setClientDestination(ClientDestination clientDestination) {
        this.clientDestination = clientDestination;
        return this;
    }

    public Set<String> getAllowedRequestHeaders() {
        return this.allowedRequestHeaders;
    }

    public HttpRepositoryOptions setAllowedRequestHeaders(Set<String> allowedRequestHeaders) {
        this.allowedRequestHeaders = allowedRequestHeaders;
        return this;
    }

    public CustomHttpHeader getCustomHttpHeader() {
        return this.customHttpHeader;
    }

    public HttpRepositoryOptions setCustomHttpHeader(CustomHttpHeader customHttpHeader) {
        this.customHttpHeader = customHttpHeader;
        return this;
    }

    @GenIgnore
    public List<Pattern> getAllowedRequestHeadersPatterns() {
        return this.allowedRequestHeaderPatterns;
    }

    @GenIgnore
    public HttpRepositoryOptions setAllowedRequestHeaderPatterns(List<Pattern> allowedRequestHeaderPatterns) {
        this.allowedRequestHeaderPatterns = allowedRequestHeaderPatterns;
        return this;
    }
}

