/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.repository.http;

import io.knotx.configuration.CustomHttpHeader;
import io.knotx.repository.http.ClientDestination;
import io.knotx.repository.http.HttpRepositoryOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.LinkedHashSet;
import java.util.Map;

class HttpRepositoryOptionsConverter {
    HttpRepositoryOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, HttpRepositoryOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "address": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAddress((String)member.getValue());
                    break;
                }
                case "allowedRequestHeaders": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setAllowedRequestHeaders(list);
                    break;
                }
                case "clientDestination": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setClientDestination(new ClientDestination((JsonObject)member.getValue()));
                    break;
                }
                case "clientOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setClientOptions(new HttpClientOptions((JsonObject)member.getValue()));
                    break;
                }
                case "customHttpHeader": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCustomHttpHeader(new CustomHttpHeader((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(HttpRepositoryOptions obj, JsonObject json) {
        HttpRepositoryOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(HttpRepositoryOptions obj, Map<String, Object> json) {
        if (obj.getAddress() != null) {
            json.put("address", obj.getAddress());
        }
        if (obj.getAllowedRequestHeaders() != null) {
            JsonArray array = new JsonArray();
            obj.getAllowedRequestHeaders().forEach(item -> array.add(item));
            json.put("allowedRequestHeaders", array);
        }
        if (obj.getClientDestination() != null) {
            json.put("clientDestination", obj.getClientDestination().toJson());
        }
        if (obj.getClientOptions() != null) {
            json.put("clientOptions", obj.getClientOptions().toJson());
        }
        if (obj.getCustomHttpHeader() != null) {
            json.put("customHttpHeader", obj.getCustomHttpHeader().toJson());
        }
    }
}

