/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.dataobjects.ClientResponse;
import io.knotx.dataobjects.KnotContext;
import io.knotx.reactivex.proxy.KnotProxy;
import io.knotx.server.configuration.KnotxServerOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.ext.web.RoutingContext;

public class KnotxAssemblerHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxAssemblerHandler.class);
    private KnotProxy assembler;
    private KnotxServerOptions configuration;

    private KnotxAssemblerHandler(Vertx vertx, KnotxServerOptions configuration) {
        this.configuration = configuration;
        this.assembler = KnotProxy.createProxyWithOptions(vertx, configuration.getDefaultFlow().getAssembler(), configuration.getDeliveryOptions());
    }

    static KnotxAssemblerHandler create(Vertx vertx, KnotxServerOptions configuration) {
        return new KnotxAssemblerHandler(vertx, configuration);
    }

    public void handle(RoutingContext context) {
        KnotContext knotContext = (KnotContext)context.get("knotContext");
        if (this.isOkClientResponse(knotContext.getClientResponse())) {
            this.assembler.rxProcess(knotContext).doOnSuccess(this::traceMessage).subscribe(ctx -> {
                if (this.isOkClientResponse(ctx.getClientResponse())) {
                    this.sendResponse(context, ctx.getClientResponse());
                } else {
                    context.fail(ctx.getClientResponse().getStatusCode());
                }
            }, error -> {
                LOGGER.error((Object)"Error happened while communicating with {} engine", error, new Object[]{this.configuration.getDefaultFlow().getSplitter()});
                context.fail(error);
            });
        } else {
            this.sendResponse(context, knotContext.getClientResponse());
        }
    }

    private boolean isOkClientResponse(ClientResponse clientResponse) {
        return clientResponse.getStatusCode() == HttpResponseStatus.OK.code();
    }

    private void sendResponse(RoutingContext context, ClientResponse clientResponse) {
        HttpServerResponse httpResponse = context.response();
        this.writeHeaders(context.response(), clientResponse);
        httpResponse.setStatusCode(clientResponse.getStatusCode());
        if (this.isOkClientResponse(clientResponse)) {
            httpResponse.end(io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)clientResponse.getBody()));
        } else {
            httpResponse.end();
        }
    }

    private void writeHeaders(HttpServerResponse response, ClientResponse clientResponse) {
        clientResponse.getHeaders().names().stream().filter(this::headerFilter).forEach(name -> clientResponse.getHeaders().getAll(name).forEach(value -> response.headers().add(name, value)));
        response.headers().remove(HttpHeaders.CONTENT_LENGTH.toString());
    }

    private Boolean headerFilter(String name) {
        return this.configuration.getAllowedResponseHeaders().contains(name.toLowerCase());
    }

    private void traceMessage(KnotContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Got message from <fragment-assembler> with value <{}>", new Object[]{ctx.toJson().encode()});
        }
    }
}

