/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.dataobjects.KnotContext;
import io.knotx.reactivex.proxy.KnotProxy;
import io.knotx.server.configuration.KnotxServerOptions;
import io.knotx.server.configuration.RoutingEntry;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class KnotxEngineHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxEngineHandler.class);
    private Vertx vertx;
    private KnotxServerOptions configuration;
    private String address;
    private Map<String, RoutingEntry> routing;
    private Map<String, KnotProxy> proxies;

    private KnotxEngineHandler(Vertx vertx, KnotxServerOptions configuration, String address, Map<String, RoutingEntry> routing) {
        this.vertx = vertx;
        this.configuration = configuration;
        this.address = address;
        this.routing = routing;
        this.proxies = new HashMap<String, KnotProxy>();
    }

    static KnotxEngineHandler create(Vertx vertx, KnotxServerOptions configuration, String address, Map<String, RoutingEntry> routing) {
        return new KnotxEngineHandler(vertx, configuration, address, routing);
    }

    public void handle(RoutingContext context) {
        try {
            this.handleRoute(context, this.address, this.routing);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Something very unexpected happened", (Throwable)ex);
            context.fail((Throwable)ex);
        }
    }

    private void handleRoute(RoutingContext context, String address, Map<String, RoutingEntry> routing) {
        KnotContext knotContext = (KnotContext)context.get("knotContext");
        this.proxies.computeIfAbsent(address, adr -> KnotProxy.createProxyWithOptions(this.vertx, adr, this.configuration.getDeliveryOptions())).rxProcess(knotContext).doOnSuccess(ctx -> context.put("knotContext", ctx)).subscribe(ctx -> {
            if (StringUtils.isNotBlank((CharSequence)ctx.getTransition())) {
                this.doTransition(context, (KnotContext)ctx, routing);
            } else {
                this.doEndProcessing(context, (KnotContext)ctx);
            }
        }, error -> {
            LOGGER.error((Object)"Error happened while communicating with {} engine", error, new Object[]{address});
            context.fail(error);
        });
    }

    private void doTransition(RoutingContext context, KnotContext ctx, Map<String, RoutingEntry> routing) {
        RoutingEntry entry = routing.get(ctx.getTransition());
        if (entry != null) {
            this.handleRoute(context, entry.getAddress(), entry.getOnTransition());
        } else {
            LOGGER.debug((Object)"Received transition '{}' from '{}'. No further routing available for the transition. Go to the response generation.", new Object[]{ctx.getTransition(), this.address});
            context.put("knotContext", (Object)ctx);
            context.next();
        }
    }

    private void doEndProcessing(RoutingContext context, KnotContext ctx) {
        LOGGER.debug((Object)"Request processing finished by {} Knot. Go to the response generation", new Object[]{this.address});
        context.put("knotContext", (Object)ctx);
        context.next();
    }
}

