/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.dataobjects.Fragment;
import io.knotx.dataobjects.KnotContext;
import io.knotx.reactivex.proxy.KnotProxy;
import io.knotx.server.configuration.KnotxServerOptions;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KnotxGatewayContextHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxGatewayContextHandler.class);
    private Vertx vertx;
    private KnotxServerOptions configuration;
    private String address;
    private Map<String, KnotProxy> proxies;

    private KnotxGatewayContextHandler(Vertx vertx, KnotxServerOptions configuration, String address) {
        this.vertx = vertx;
        this.configuration = configuration;
        this.address = address;
        this.proxies = new HashMap<String, KnotProxy>();
    }

    static KnotxGatewayContextHandler create(Vertx vertx, KnotxServerOptions configuration, String address) {
        return new KnotxGatewayContextHandler(vertx, configuration, address);
    }

    public void handle(RoutingContext context) {
        KnotContext knotContext = (KnotContext)context.get("knotContext");
        String bodyAsString = context.getBodyAsString();
        if (StringUtils.isNotBlank((CharSequence)bodyAsString)) {
            knotContext.setFragments(Collections.singletonList(Fragment.raw(bodyAsString)));
        }
        LOGGER.debug((Object)"CustomFlow: Routing the traffic to '{}'", new Object[]{this.address});
        this.proxies.computeIfAbsent(this.address, adr -> KnotProxy.createProxyWithOptions(this.vertx, adr, this.configuration.getDeliveryOptions())).rxProcess(knotContext).doOnSuccess(ctx -> context.put("knotContext", ctx)).subscribe(ctx -> {
            context.put("knotContext", ctx);
            context.next();
        }, error -> {
            LOGGER.error((Object)"Error happened while communicating with {} engine", error, new Object[]{this.address});
            context.fail(error);
        });
    }
}

