/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.dataobjects.ClientResponse;
import io.knotx.dataobjects.KnotContext;
import io.knotx.reactivex.proxy.RepositoryConnectorProxy;
import io.knotx.server.configuration.KnotxServerOptions;
import io.knotx.server.configuration.RepositoryEntry;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class KnotxRepositoryHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxRepositoryHandler.class);
    private Vertx vertx;
    private KnotxServerOptions configuration;
    private Map<String, RepositoryConnectorProxy> proxies;

    private KnotxRepositoryHandler(Vertx vertx, KnotxServerOptions configuration) {
        this.vertx = vertx;
        this.configuration = configuration;
        this.proxies = new HashMap<String, RepositoryConnectorProxy>();
    }

    static KnotxRepositoryHandler create(Vertx vertx, KnotxServerOptions configuration) {
        return new KnotxRepositoryHandler(vertx, configuration);
    }

    public void handle(RoutingContext context) {
        Optional<RepositoryEntry> repositoryEntry = this.configuration.getDefaultFlow().repositoryForPath(context.request().path());
        KnotContext knotContext = (KnotContext)context.get("knotContext");
        if (repositoryEntry.isPresent()) {
            this.proxies.computeIfAbsent(repositoryEntry.get().getAddress(), adr -> RepositoryConnectorProxy.createProxyWithOptions(this.vertx, adr, this.configuration.getDeliveryOptions())).rxProcess(knotContext.getClientRequest()).doOnSuccess(this::traceMessage).subscribe(repoResponse -> this.handleRepositoryResponse((ClientResponse)repoResponse, context, (RepositoryEntry)repositoryEntry.get(), knotContext), arg_0 -> ((RoutingContext)context).fail(arg_0));
        } else {
            context.fail(HttpResponseStatus.NOT_FOUND.code());
        }
    }

    void handleRepositoryResponse(ClientResponse repoResponse, RoutingContext context, RepositoryEntry repositoryEntry, KnotContext knotContext) {
        if (this.isSuccessResponse(repoResponse)) {
            if (repositoryEntry.isDoProcessing()) {
                knotContext.setClientResponse(repoResponse);
                context.put("knotContext", (Object)knotContext);
                context.next();
            } else {
                this.endResponse(repoResponse, context);
            }
        } else {
            this.endResponse(repoResponse, context);
        }
    }

    private void endResponse(ClientResponse repoResponse, RoutingContext context) {
        this.writeHeaders(context.response(), repoResponse.getHeaders());
        context.response().setStatusCode(repoResponse.getStatusCode());
        if (repoResponse.getBody() != null) {
            context.response().end(io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)repoResponse.getBody()));
        } else {
            context.response().end();
        }
    }

    private boolean isSuccessResponse(ClientResponse repoResponse) {
        return HttpResponseStatus.OK.code() == repoResponse.getStatusCode();
    }

    private void traceMessage(ClientResponse message) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Got message from <template-repository> with value <{}>", new Object[]{message.getBody()});
        }
    }

    private void writeHeaders(HttpServerResponse response, MultiMap headers) {
        headers.names().stream().filter(this::headerFilter).forEach(name -> headers.getAll(name).forEach(value -> response.putHeader(name, value)));
    }

    private Boolean headerFilter(String name) {
        return this.configuration.getAllowedResponseHeaders().contains(name.toLowerCase());
    }
}

