/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.KnotxAssemblerHandler;
import io.knotx.server.KnotxContextHandler;
import io.knotx.server.KnotxEngineHandler;
import io.knotx.server.KnotxGatewayContextHandler;
import io.knotx.server.KnotxGatewayResponseProviderHandler;
import io.knotx.server.KnotxHeaderHandler;
import io.knotx.server.KnotxRepositoryHandler;
import io.knotx.server.KnotxSplitterHandler;
import io.knotx.server.SupportedMethodsAndPathsHandler;
import io.knotx.server.configuration.KnotxCSRFOptions;
import io.knotx.server.configuration.KnotxServerOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.handler.LoggerFormat;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.handler.BodyHandler;
import io.vertx.reactivex.ext.web.handler.CSRFHandler;
import io.vertx.reactivex.ext.web.handler.ErrorHandler;
import io.vertx.reactivex.ext.web.handler.LoggerHandler;

public class KnotxServerVerticle
extends AbstractVerticle {
    public static final String KNOTX_PORT_PROP_NAME = "knotx.port";
    public static final String KNOTX_FILE_UPLOAD_DIR_PROPERTY = "knotx.fileUploadDir";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxServerVerticle.class);
    private static final HttpResponseStatus BAD_REQUEST = HttpResponseStatus.BAD_REQUEST;
    private KnotxServerOptions options;

    public void init(Vertx vertx, Context context) {
        super.init(vertx, context);
        this.options = new KnotxServerOptions(this.config());
    }

    public void start(Future<Void> fut) {
        LOGGER.info((Object)"Starting <{}>", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        KnotxCSRFOptions csrfConfig = this.options.getCsrfConfig();
        CSRFHandler csrfHandler = CSRFHandler.create((String)csrfConfig.getSecret()).setNagHttps(true).setCookieName(csrfConfig.getCookieName()).setCookiePath(csrfConfig.getCookiePath()).setHeaderName(csrfConfig.getHeaderName()).setTimeout(csrfConfig.getTimeout());
        Router router = Router.router((io.vertx.reactivex.core.Vertx)this.vertx);
        if (this.options.getAccessLog().isEnabled()) {
            router.route().handler((Handler)LoggerHandler.create((boolean)this.options.getAccessLog().isImmediate(), (LoggerFormat)this.options.getAccessLog().getFormat()));
        }
        router.route().handler((Handler)KnotxHeaderHandler.create(this.options));
        router.route().handler((Handler)SupportedMethodsAndPathsHandler.create(this.options));
        router.route().handler((Handler)BodyHandler.create((String)this.options.getFileUploadDirectory()).setBodyLimit(this.options.getFileUploadLimit().longValue()));
        router.route().handler(KnotxContextHandler.create());
        this.options.getDefaultFlow().getRouting().forEach((key, value) -> value.getItems().forEach(criteria -> {
            HttpMethod method = HttpMethod.valueOf((String)key.toUpperCase());
            if (criteria.isCsrf()) {
                router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)csrfHandler);
            }
            router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxRepositoryHandler.create(this.vertx, this.options));
            router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxSplitterHandler.create(this.vertx, this.options));
            router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxEngineHandler.create(this.vertx, this.options, criteria.getAddress(), criteria.getOnTransition()));
            router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxAssemblerHandler.create(this.vertx, this.options));
        }));
        if (this.options.getCustomFlow() != null) {
            this.options.getCustomFlow().getRouting().forEach((key, value) -> value.getItems().forEach(criteria -> {
                HttpMethod method = HttpMethod.valueOf((String)key.toUpperCase());
                if (criteria.isCsrf()) {
                    router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)csrfHandler);
                }
                router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxGatewayContextHandler.create(this.vertx, this.options, criteria.getAddress()));
                router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxEngineHandler.create(this.vertx, this.options, criteria.getAddress(), criteria.getOnTransition()));
                router.route().method(method).pathRegex(criteria.getPath()).handler((Handler)KnotxGatewayResponseProviderHandler.create(this.vertx, this.options));
            }));
        }
        router.route().failureHandler((Handler)ErrorHandler.create((boolean)this.options.isDisplayExceptionDetails()));
        HttpServer httpServer = this.vertx.createHttpServer(this.options.getServerOptions());
        if (this.options.isDropRequests()) {
            httpServer.requestStream().toFlowable().map(HttpServerRequest::pause).onBackpressureBuffer(this.options.getBackpressureBufferCapacity(), () -> LOGGER.warn((Object)"Backpressure buffer is overflown. Dropping request"), this.options.getBackpressureStrategy()).onBackpressureDrop(req -> req.response().setStatusCode(this.options.getDropRequestResponseCode()).end()).observeOn(RxHelper.scheduler((Vertx)this.vertx.getDelegate())).subscribe(req -> {
                req.resume();
                this.routeSafe((HttpServerRequest)req, router);
            }, error -> LOGGER.error((Object)"Exception while processing!", error));
        } else {
            httpServer.requestHandler(req -> this.routeSafe((HttpServerRequest)req, router));
        }
        httpServer.rxListen().subscribe(ok -> {
            LOGGER.info((Object)"Knot.x HTTP Server started. Listening on port {}", new Object[]{this.options.getServerOptions().getPort()});
            fut.complete();
        }, error -> {
            LOGGER.error((Object)"Unable to start Knot.x HTTP Server.", error.getCause());
            fut.fail(error);
        });
    }

    private void routeSafe(HttpServerRequest req, Router router) {
        try {
            router.accept(req);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn((Object)"Problem decoding Query String ", (Throwable)ex);
            req.response().setStatusCode(BAD_REQUEST.code()).setStatusMessage(BAD_REQUEST.reasonPhrase()).end("Invalid characters in Query Parameter");
        }
    }
}

