/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.dataobjects.KnotContext;
import io.knotx.reactivex.proxy.KnotProxy;
import io.knotx.server.configuration.KnotxServerOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.RoutingContext;

public class KnotxSplitterHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxSplitterHandler.class);
    private KnotProxy splitter;
    private KnotxServerOptions configuration;

    private KnotxSplitterHandler(Vertx vertx, KnotxServerOptions configuration) {
        this.splitter = KnotProxy.createProxyWithOptions(vertx, configuration.getDefaultFlow().getSplitter(), configuration.getDeliveryOptions());
        this.configuration = configuration;
    }

    public static KnotxSplitterHandler create(Vertx vertx, KnotxServerOptions configuration) {
        return new KnotxSplitterHandler(vertx, configuration);
    }

    public void handle(RoutingContext context) {
        KnotContext knotContext = (KnotContext)context.get("knotContext");
        this.splitter.rxProcess(knotContext).doOnSuccess(this::traceMessage).subscribe(ctx -> {
            if (ctx.getClientResponse().getStatusCode() == HttpResponseStatus.OK.code()) {
                context.put("knotContext", ctx);
                context.next();
            } else {
                context.fail(ctx.getClientResponse().getStatusCode());
            }
        }, error -> {
            LOGGER.error((Object)"Error happened while communicating with {} engine", error, new Object[]{this.configuration.getDefaultFlow().getSplitter()});
            context.fail(error);
        });
    }

    private void traceMessage(KnotContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Got message from <fragment-splitter> with value <{}>", new Object[]{ctx});
        }
    }
}

