/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.configuration.KnotxFlowSettings;
import io.knotx.server.configuration.KnotxServerOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.ext.web.RoutingContext;

public class SupportedMethodsAndPathsHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportedMethodsAndPathsHandler.class);
    private final KnotxFlowSettings defaultFlow;
    private final KnotxFlowSettings customFlow;

    private SupportedMethodsAndPathsHandler(KnotxServerOptions configuration) {
        this.defaultFlow = configuration.getDefaultFlow();
        this.customFlow = configuration.getCustomFlow();
    }

    public static SupportedMethodsAndPathsHandler create(KnotxServerOptions configuration) {
        return new SupportedMethodsAndPathsHandler(configuration);
    }

    public void handle(RoutingContext context) {
        String path = context.request().path();
        HttpMethod method = context.request().method();
        if (this.isPathSupportedByFlow(path, this.defaultFlow)) {
            if (this.isMethodAllowedInFlow(method, this.defaultFlow)) {
                context.next();
            } else {
                LOGGER.warn((Object)"{} path supported by DefaultFlow. {} method not allowed.", new Object[]{path, method});
                context.fail(HttpResponseStatus.METHOD_NOT_ALLOWED.code());
            }
        } else if (this.isPathSupportedByFlow(path, this.customFlow)) {
            if (this.isMethodAllowedInFlow(method, this.customFlow)) {
                context.next();
            } else {
                LOGGER.warn((Object)"{} path supported by CustomFlow. {} method not allowed.", new Object[]{path, method});
                context.fail(HttpResponseStatus.METHOD_NOT_ALLOWED.code());
            }
        } else {
            LOGGER.warn((Object)"{} {} is not supported by default and custom flows.", new Object[]{method, path});
            context.fail(HttpResponseStatus.NOT_FOUND.code());
        }
    }

    private boolean isPathSupportedByFlow(String path, KnotxFlowSettings flow) {
        return flow != null && flow.getRouting() != null && flow.getRouting().values().stream().anyMatch(list -> list.getItems().stream().anyMatch(item -> path.matches(item.getPath())));
    }

    private boolean isMethodAllowedInFlow(HttpMethod method, KnotxFlowSettings flow) {
        return flow != null & flow.getRouting() != null && flow.getRouting().keySet().stream().anyMatch(item -> HttpMethod.valueOf((String)item.toUpperCase()) == method);
    }
}

