/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.AccessLogOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.handler.LoggerFormat;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class AccessLogOptions {
    private static final boolean DEFAULT_LOGGER_IMMEDIATE = false;
    private static final LoggerFormat DEFAULT_LOGGER_FORMAT = LoggerFormat.DEFAULT;
    private boolean enabled;
    private boolean immediate;
    private LoggerFormat format;

    public AccessLogOptions() {
        this.init();
    }

    public AccessLogOptions(AccessLogOptions other) {
        this.enabled = other.enabled;
        this.immediate = other.immediate;
        this.format = other.format;
    }

    public AccessLogOptions(JsonObject json) {
        this.init();
        AccessLogOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AccessLogOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.enabled = false;
        this.immediate = false;
        this.format = DEFAULT_LOGGER_FORMAT;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public AccessLogOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public AccessLogOptions setImmediate(boolean immediate) {
        this.immediate = immediate;
        return this;
    }

    public LoggerFormat getFormat() {
        return this.format;
    }

    public AccessLogOptions setFormat(LoggerFormat format) {
        this.format = format;
        return this;
    }
}

