/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.KnotxCSRFOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

@DataObject(generateConverter=true, publicConverter=false)
public class KnotxCSRFOptions {
    private static final long DEFAULT_TIMEOUT = 1800000L;
    private String cookieName;
    private String cookiePath;
    private String headerName;
    private String secret;
    private long timeout;

    public KnotxCSRFOptions() {
        this.init();
    }

    public KnotxCSRFOptions(KnotxCSRFOptions other) {
        this.cookieName = other.cookieName;
        this.cookiePath = other.cookiePath;
        this.headerName = other.headerName;
        this.secret = other.secret;
        this.timeout = other.timeout;
    }

    public KnotxCSRFOptions(JsonObject json) {
        this.init();
        KnotxCSRFOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        KnotxCSRFOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.secret = RandomStringUtils.random((int)20);
        this.cookieName = "XSRF-TOKEN";
        this.cookiePath = "/";
        this.headerName = "X-XSRF-TOKEN";
        this.timeout = 1800000L;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public KnotxCSRFOptions setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public KnotxCSRFOptions setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public KnotxCSRFOptions setHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    public String getSecret() {
        return this.secret;
    }

    public KnotxCSRFOptions setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public KnotxCSRFOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }
}

