/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.KnotxFlowSettingsConverter;
import io.knotx.server.configuration.MethodRoutingEntries;
import io.knotx.server.configuration.RepositoryEntry;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@DataObject(generateConverter=true, publicConverter=false)
public class KnotxFlowSettings {
    private static final String DEFAULT_SPLITTER_ADDRESS = "knotx.core.splitter";
    private static final String DEFAULT_ASSEMBLER_ADDRESS = "knotx.core.assembler";
    private static final String DEFAULT_RESPONSE_PROVIDER_ADDRESS = "knotx.gateway.responseprovider";
    private List<RepositoryEntry> repositories;
    private String splitter;
    private String assembler;
    private String responseProvider;
    private Map<String, MethodRoutingEntries> routing;

    public KnotxFlowSettings() {
        this.init();
    }

    public KnotxFlowSettings(KnotxFlowSettings other) {
        this.repositories = new ArrayList<RepositoryEntry>(other.repositories);
        this.splitter = other.splitter;
        this.assembler = other.assembler;
        this.responseProvider = other.responseProvider;
        this.routing = new HashMap<String, MethodRoutingEntries>(other.routing);
    }

    public KnotxFlowSettings(JsonObject json) {
        this.init();
        KnotxFlowSettingsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        KnotxFlowSettingsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.repositories = new ArrayList<RepositoryEntry>();
        this.splitter = DEFAULT_SPLITTER_ADDRESS;
        this.assembler = DEFAULT_ASSEMBLER_ADDRESS;
        this.responseProvider = DEFAULT_RESPONSE_PROVIDER_ADDRESS;
        this.routing = new HashMap<String, MethodRoutingEntries>();
    }

    public Optional<RepositoryEntry> repositoryForPath(String path) {
        return this.repositories.stream().filter(mapping -> path.matches(mapping.getPath())).findFirst();
    }

    public List<RepositoryEntry> getRepositories() {
        return this.repositories;
    }

    public KnotxFlowSettings setRepositories(List<RepositoryEntry> repositoryAddressMapping) {
        this.repositories = repositoryAddressMapping;
        return this;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public KnotxFlowSettings setSplitter(String splitter) {
        this.splitter = splitter;
        return this;
    }

    public String getAssembler() {
        return this.assembler;
    }

    public KnotxFlowSettings setAssembler(String assembler) {
        this.assembler = assembler;
        return this;
    }

    public String getResponseProvider() {
        return this.responseProvider;
    }

    public KnotxFlowSettings setResponseProvider(String responseProvider) {
        this.responseProvider = responseProvider;
        return this;
    }

    public Map<String, MethodRoutingEntries> getRouting() {
        return this.routing;
    }

    public KnotxFlowSettings setRouting(Map<String, MethodRoutingEntries> engineRouting) {
        this.routing = engineRouting;
        return this;
    }
}

