/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.KnotxFlowSettings;
import io.knotx.server.configuration.MethodRoutingEntries;
import io.knotx.server.configuration.RepositoryEntry;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

class KnotxFlowSettingsConverter {
    KnotxFlowSettingsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, KnotxFlowSettings obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "assembler": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAssembler((String)member.getValue());
                    break;
                }
                case "repositories": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<RepositoryEntry> list = new ArrayList<RepositoryEntry>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new RepositoryEntry((JsonObject)item));
                        }
                    });
                    obj.setRepositories(list);
                    break;
                }
                case "responseProvider": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setResponseProvider((String)member.getValue());
                    break;
                }
                case "routing": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, MethodRoutingEntries> map = new LinkedHashMap<String, MethodRoutingEntries>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), new MethodRoutingEntries((JsonObject)entry.getValue()));
                        }
                    });
                    obj.setRouting(map);
                    break;
                }
                case "splitter": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSplitter((String)member.getValue());
                }
            }
        }
    }

    static void toJson(KnotxFlowSettings obj, JsonObject json) {
        KnotxFlowSettingsConverter.toJson(obj, json.getMap());
    }

    static void toJson(KnotxFlowSettings obj, Map<String, Object> json) {
        if (obj.getAssembler() != null) {
            json.put("assembler", obj.getAssembler());
        }
        if (obj.getRepositories() != null) {
            JsonArray array = new JsonArray();
            obj.getRepositories().forEach(item -> array.add(item.toJson()));
            json.put("repositories", array);
        }
        if (obj.getResponseProvider() != null) {
            json.put("responseProvider", obj.getResponseProvider());
        }
        if (obj.getRouting() != null) {
            JsonObject map = new JsonObject();
            obj.getRouting().forEach((key, value) -> map.put(key, value.toJson()));
            json.put("routing", map);
        }
        if (obj.getSplitter() != null) {
            json.put("splitter", obj.getSplitter());
        }
    }
}

