/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.configuration.CustomHttpHeader;
import io.knotx.server.configuration.AccessLogOptions;
import io.knotx.server.configuration.KnotxCSRFOptions;
import io.knotx.server.configuration.KnotxFlowSettings;
import io.knotx.server.configuration.KnotxServerOptionsConverter;
import io.knotx.util.StringUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.BackpressureOverflowStrategy;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@DataObject(generateConverter=true, publicConverter=false)
public class KnotxServerOptions {
    public static final long DEFAULT_UPLOAD_LIMIT = -1L;
    private static final String DEFAULT_UPLOAD_DIRECTORY = StringUtil.getString("knotx.fileUploadDir", "file-uploads");
    private static final boolean DEFAULT_DISPLAY_EXCEPTIONS = false;
    private static final boolean DEFAULT_DROP_REQUESTS = false;
    private static final int DEFAULT_DROP_REQUESTS_RESPONSE_CODE = HttpResponseStatus.TOO_MANY_REQUESTS.code();
    private static final long DEFAULT_BACKPRESSURE_BUFFER_SIZE = 1000L;
    private static final BackpressureOverflowStrategy DEFAULT_BACKPRESSURE_STRATEGY = BackpressureOverflowStrategy.DROP_LATEST;
    private Long fileUploadLimit;
    private String fileUploadDirectory;
    private boolean displayExceptionDetails;
    private HttpServerOptions serverOptions;
    private DeliveryOptions deliveryOptions;
    private KnotxCSRFOptions csrfConfig;
    private KnotxFlowSettings defaultFlow;
    private KnotxFlowSettings customFlow;
    private Set<String> allowedResponseHeaders;
    private CustomHttpHeader customResponseHeader;
    private AccessLogOptions accessLog;
    private boolean dropRequests;
    private int dropRequestResponseCode;
    private long backpressureBufferCapacity;
    private BackpressureOverflowStrategy backpressureStrategy;

    public KnotxServerOptions() {
        this.init();
    }

    public KnotxServerOptions(KnotxServerOptions other) {
        this.fileUploadLimit = other.fileUploadLimit;
        this.fileUploadDirectory = other.fileUploadDirectory;
        this.displayExceptionDetails = other.displayExceptionDetails;
        this.allowedResponseHeaders = new HashSet<String>(other.allowedResponseHeaders);
        this.serverOptions = new HttpServerOptions(other.serverOptions);
        this.deliveryOptions = new DeliveryOptions(other.deliveryOptions);
        this.customResponseHeader = new CustomHttpHeader(other.customResponseHeader);
        this.csrfConfig = new KnotxCSRFOptions(other.csrfConfig);
        this.defaultFlow = new KnotxFlowSettings(other.defaultFlow);
        this.customFlow = new KnotxFlowSettings(other.customFlow);
        this.accessLog = new AccessLogOptions(other.accessLog);
        this.dropRequests = other.dropRequests;
        this.dropRequestResponseCode = other.dropRequestResponseCode;
        this.backpressureBufferCapacity = other.backpressureBufferCapacity;
        this.backpressureStrategy = other.backpressureStrategy;
    }

    public KnotxServerOptions(JsonObject json) {
        this.init();
        KnotxServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.allowedResponseHeaders = this.allowedResponseHeaders.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.serverOptions.setPort(Integer.getInteger("knotx.port", this.serverOptions.getPort()).intValue());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        KnotxServerOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.fileUploadLimit = -1L;
        this.fileUploadDirectory = DEFAULT_UPLOAD_DIRECTORY;
        this.displayExceptionDetails = false;
        this.allowedResponseHeaders = new HashSet<String>();
        this.allowedResponseHeaders = this.allowedResponseHeaders.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.deliveryOptions = new DeliveryOptions();
        this.serverOptions = new HttpServerOptions();
        this.customResponseHeader = null;
        this.csrfConfig = new KnotxCSRFOptions();
        this.defaultFlow = new KnotxFlowSettings();
        this.customFlow = null;
        this.accessLog = new AccessLogOptions();
        this.dropRequests = false;
        this.dropRequestResponseCode = DEFAULT_DROP_REQUESTS_RESPONSE_CODE;
        this.backpressureBufferCapacity = 1000L;
        this.backpressureStrategy = DEFAULT_BACKPRESSURE_STRATEGY;
    }

    public Long getFileUploadLimit() {
        return this.fileUploadLimit;
    }

    public KnotxServerOptions setFileUploadLimit(Long fileUploadLimit) {
        this.fileUploadLimit = fileUploadLimit;
        return this;
    }

    public String getFileUploadDirectory() {
        return this.fileUploadDirectory;
    }

    public KnotxServerOptions setFileUploadDirectory(String fileUploadDirectory) {
        this.fileUploadDirectory = fileUploadDirectory;
        return this;
    }

    public boolean isDisplayExceptionDetails() {
        return this.displayExceptionDetails;
    }

    public KnotxServerOptions setDisplayExceptionDetails(boolean displayExceptionDetails) {
        this.displayExceptionDetails = displayExceptionDetails;
        return this;
    }

    public HttpServerOptions getServerOptions() {
        return this.serverOptions;
    }

    public KnotxServerOptions setServerOptions(HttpServerOptions serverOptions) {
        this.serverOptions = serverOptions;
        return this;
    }

    public DeliveryOptions getDeliveryOptions() {
        return this.deliveryOptions;
    }

    public KnotxServerOptions setDeliveryOptions(DeliveryOptions deliveryOptions) {
        this.deliveryOptions = deliveryOptions;
        return this;
    }

    public KnotxCSRFOptions getCsrfConfig() {
        return this.csrfConfig;
    }

    public KnotxServerOptions setCsrfConfig(KnotxCSRFOptions csrfConfig) {
        this.csrfConfig = csrfConfig;
        return this;
    }

    public KnotxFlowSettings getDefaultFlow() {
        return this.defaultFlow;
    }

    public KnotxServerOptions setDefaultFlow(KnotxFlowSettings defaultFlow) {
        this.defaultFlow = defaultFlow;
        return this;
    }

    public KnotxFlowSettings getCustomFlow() {
        return this.customFlow;
    }

    public KnotxServerOptions setCustomFlow(KnotxFlowSettings customFlow) {
        this.customFlow = customFlow;
        return this;
    }

    public Set<String> getAllowedResponseHeaders() {
        return this.allowedResponseHeaders;
    }

    public KnotxServerOptions setAllowedResponseHeaders(Set<String> allowedResponseHeaders) {
        this.allowedResponseHeaders = allowedResponseHeaders.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return this;
    }

    public CustomHttpHeader getCustomResponseHeader() {
        return this.customResponseHeader;
    }

    public KnotxServerOptions setCustomResponseHeader(CustomHttpHeader customResponseHeader) {
        this.customResponseHeader = customResponseHeader;
        return this;
    }

    public AccessLogOptions getAccessLog() {
        return this.accessLog;
    }

    public KnotxServerOptions setAccessLog(AccessLogOptions accessLog) {
        this.accessLog = accessLog;
        return this;
    }

    public boolean isDropRequests() {
        return this.dropRequests;
    }

    public KnotxServerOptions setDropRequests(boolean dropRequests) {
        this.dropRequests = dropRequests;
        return this;
    }

    public int getDropRequestResponseCode() {
        return this.dropRequestResponseCode;
    }

    public KnotxServerOptions setDropRequestResponseCode(int dropRequestResponseCode) {
        this.dropRequestResponseCode = dropRequestResponseCode;
        return this;
    }

    public long getBackpressureBufferCapacity() {
        return this.backpressureBufferCapacity;
    }

    public KnotxServerOptions setBackpressureBufferCapacity(long backpressureBufferCapacity) {
        this.backpressureBufferCapacity = backpressureBufferCapacity;
        return this;
    }

    public BackpressureOverflowStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    public KnotxServerOptions setBackpressureStrategy(BackpressureOverflowStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
        return this;
    }
}

