/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.configuration.CustomHttpHeader;
import io.knotx.server.configuration.AccessLogOptions;
import io.knotx.server.configuration.KnotxCSRFOptions;
import io.knotx.server.configuration.KnotxFlowSettings;
import io.knotx.server.configuration.KnotxServerOptions;
import io.reactivex.BackpressureOverflowStrategy;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.LinkedHashSet;
import java.util.Map;

class KnotxServerOptionsConverter {
    KnotxServerOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, KnotxServerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "accessLog": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setAccessLog(new AccessLogOptions((JsonObject)member.getValue()));
                    break;
                }
                case "allowedResponseHeaders": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setAllowedResponseHeaders(list);
                    break;
                }
                case "backpressureBufferCapacity": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBackpressureBufferCapacity(((Number)member.getValue()).longValue());
                    break;
                }
                case "backpressureStrategy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBackpressureStrategy(BackpressureOverflowStrategy.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "csrfConfig": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCsrfConfig(new KnotxCSRFOptions((JsonObject)member.getValue()));
                    break;
                }
                case "customFlow": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCustomFlow(new KnotxFlowSettings((JsonObject)member.getValue()));
                    break;
                }
                case "customResponseHeader": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCustomResponseHeader(new CustomHttpHeader((JsonObject)member.getValue()));
                    break;
                }
                case "defaultFlow": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setDefaultFlow(new KnotxFlowSettings((JsonObject)member.getValue()));
                    break;
                }
                case "deliveryOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setDeliveryOptions(new DeliveryOptions((JsonObject)member.getValue()));
                    break;
                }
                case "displayExceptionDetails": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDisplayExceptionDetails((Boolean)member.getValue());
                    break;
                }
                case "dropRequestResponseCode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDropRequestResponseCode(((Number)member.getValue()).intValue());
                    break;
                }
                case "dropRequests": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDropRequests((Boolean)member.getValue());
                    break;
                }
                case "fileUploadDirectory": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFileUploadDirectory((String)member.getValue());
                    break;
                }
                case "fileUploadLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFileUploadLimit(((Number)member.getValue()).longValue());
                    break;
                }
                case "serverOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setServerOptions(new HttpServerOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(KnotxServerOptions obj, JsonObject json) {
        KnotxServerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(KnotxServerOptions obj, Map<String, Object> json) {
        if (obj.getAccessLog() != null) {
            json.put("accessLog", obj.getAccessLog().toJson());
        }
        if (obj.getAllowedResponseHeaders() != null) {
            JsonArray array = new JsonArray();
            obj.getAllowedResponseHeaders().forEach(item -> array.add(item));
            json.put("allowedResponseHeaders", array);
        }
        json.put("backpressureBufferCapacity", obj.getBackpressureBufferCapacity());
        if (obj.getBackpressureStrategy() != null) {
            json.put("backpressureStrategy", obj.getBackpressureStrategy().name());
        }
        if (obj.getCsrfConfig() != null) {
            json.put("csrfConfig", obj.getCsrfConfig().toJson());
        }
        if (obj.getCustomFlow() != null) {
            json.put("customFlow", obj.getCustomFlow().toJson());
        }
        if (obj.getCustomResponseHeader() != null) {
            json.put("customResponseHeader", obj.getCustomResponseHeader().toJson());
        }
        if (obj.getDefaultFlow() != null) {
            json.put("defaultFlow", obj.getDefaultFlow().toJson());
        }
        if (obj.getDeliveryOptions() != null) {
            json.put("deliveryOptions", obj.getDeliveryOptions().toJson());
        }
        json.put("displayExceptionDetails", obj.isDisplayExceptionDetails());
        json.put("dropRequestResponseCode", obj.getDropRequestResponseCode());
        json.put("dropRequests", obj.isDropRequests());
        if (obj.getFileUploadDirectory() != null) {
            json.put("fileUploadDirectory", obj.getFileUploadDirectory());
        }
        if (obj.getFileUploadLimit() != null) {
            json.put("fileUploadLimit", obj.getFileUploadLimit());
        }
        if (obj.getServerOptions() != null) {
            json.put("serverOptions", obj.getServerOptions().toJson());
        }
    }
}

