/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.RepositoryEntryConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class RepositoryEntry {
    public static final boolean DEFAULT_DO_PROCESSING = true;
    private String path;
    private String address;
    private boolean doProcessing;

    public RepositoryEntry() {
        this.init();
    }

    public RepositoryEntry(RepositoryEntry other) {
        this.path = other.path;
        this.address = other.address;
        this.doProcessing = other.doProcessing;
    }

    public RepositoryEntry(JsonObject json) {
        this.init();
        RepositoryEntryConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RepositoryEntryConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.doProcessing = true;
    }

    public String getPath() {
        return this.path;
    }

    public RepositoryEntry setPath(String path) {
        this.path = path;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public RepositoryEntry setAddress(String address) {
        this.address = address;
        return this;
    }

    public boolean isDoProcessing() {
        return this.doProcessing;
    }

    public RepositoryEntry setDoProcessing(boolean doProcessing) {
        this.doProcessing = doProcessing;
        return this;
    }
}

