/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import com.google.common.collect.Maps;
import io.knotx.server.configuration.RoutingEntryConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class RoutingEntry {
    public static final boolean DEFAULT_CSRF_ENABLED = false;
    private String path;
    private boolean csrf;
    private String address;
    private Map<String, RoutingEntry> onTransition;

    public RoutingEntry() {
        this.init();
    }

    public RoutingEntry(RoutingEntry other) {
        this.path = other.path;
        this.csrf = other.csrf;
        this.address = other.address;
        this.onTransition = Maps.newHashMap(other.onTransition);
    }

    public RoutingEntry(JsonObject json) {
        this.init();
        RoutingEntryConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RoutingEntryConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.csrf = false;
        this.onTransition = new HashMap<String, RoutingEntry>();
    }

    public String getPath() {
        return this.path;
    }

    public RoutingEntry setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean isCsrf() {
        return this.csrf;
    }

    public RoutingEntry setCsrf(boolean csrfEnabled) {
        this.csrf = csrfEnabled;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public RoutingEntry setAddress(String address) {
        this.address = address;
        return this;
    }

    public Map<String, RoutingEntry> getOnTransition() {
        return this.onTransition;
    }

    public RoutingEntry setOnTransition(Map<String, RoutingEntry> onTransition) {
        this.onTransition = onTransition;
        return this;
    }
}

