/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.RoutingEntry;
import io.vertx.core.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;

class RoutingEntryConverter {
    RoutingEntryConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, RoutingEntry obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "address": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAddress((String)member.getValue());
                    break;
                }
                case "csrf": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCsrf((Boolean)member.getValue());
                    break;
                }
                case "onTransition": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, RoutingEntry> map = new LinkedHashMap<String, RoutingEntry>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), new RoutingEntry((JsonObject)entry.getValue()));
                        }
                    });
                    obj.setOnTransition(map);
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                }
            }
        }
    }

    static void toJson(RoutingEntry obj, JsonObject json) {
        RoutingEntryConverter.toJson(obj, json.getMap());
    }

    static void toJson(RoutingEntry obj, Map<String, Object> json) {
        if (obj.getAddress() != null) {
            json.put("address", obj.getAddress());
        }
        json.put("csrf", obj.isCsrf());
        if (obj.getOnTransition() != null) {
            JsonObject map = new JsonObject();
            obj.getOnTransition().forEach((key, value) -> map.put(key, value.toJson()));
            json.put("onTransition", map);
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
    }
}

