/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.splitter;

import io.knotx.dataobjects.KnotContext;
import io.knotx.knot.AbstractKnotProxy;
import io.knotx.splitter.FragmentSplitter;
import io.knotx.splitter.FragmentSplitterOptions;
import io.knotx.splitter.HtmlFragmentSplitter;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Single;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.NoSuchElementException;
import java.util.Set;

public class FragmentSplitterKnotProxyImpl
extends AbstractKnotProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentSplitterKnotProxyImpl.class);
    private final FragmentSplitter splitter;

    public FragmentSplitterKnotProxyImpl(FragmentSplitterOptions options) {
        this.splitter = new HtmlFragmentSplitter(options.getSnippetOptions());
    }

    @Override
    protected Single<KnotContext> processRequest(KnotContext knotContext) {
        try {
            knotContext.setFragments(this.splitter.split(knotContext.getClientResponse().getBody().toString()));
            knotContext.getClientResponse().setStatusCode(HttpResponseStatus.OK.code()).clearBody();
            return Single.just((Object)knotContext);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception happened during HTML splitting.", (Throwable)ex);
            return Single.just((Object)this.processError(knotContext, ex));
        }
    }

    @Override
    protected boolean shouldProcess(Set<String> knots) {
        return true;
    }

    @Override
    protected KnotContext processError(KnotContext knotContext, Throwable error) {
        HttpResponseStatus statusCode = error instanceof NoSuchElementException ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.INTERNAL_SERVER_ERROR;
        knotContext.getClientResponse().setStatusCode(statusCode.code());
        return knotContext;
    }
}

