/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.splitter;

import io.knotx.dataobjects.Fragment;
import io.knotx.fragments.SnippetPatterns;
import io.knotx.options.SnippetOptions;
import io.knotx.splitter.FragmentSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

class HtmlFragmentSplitter
implements FragmentSplitter {
    private final SnippetPatterns snippetPatterns;
    private final String defaultFallback;

    HtmlFragmentSplitter(SnippetOptions snippetOptions) {
        this.snippetPatterns = new SnippetPatterns(snippetOptions);
        this.defaultFallback = snippetOptions.getDefaultFallback();
    }

    @Override
    public List<Fragment> split(String html) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            throw new NoSuchElementException("html cannot be empty");
        }
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        List<FallbackMarker> fallbackMarkers = this.getFallbackMarkers(html);
        if (this.snippetPatterns.getAnySnippetPattern().matcher(html).matches()) {
            Matcher matcher = this.snippetPatterns.getSnippetPattern().matcher(html);
            int idx = 0;
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                if (idx < matchResult.start()) {
                    this.processMarkup(fragments, fallbackMarkers, html, idx, matchResult.start());
                }
                fragments.add(this.toSnippet(matchResult.group(1).intern().split(","), html, matchResult.start(), matchResult.end()));
                idx = matchResult.end();
            }
            if (idx < html.length()) {
                this.processMarkup(fragments, fallbackMarkers, html, idx, html.length());
            }
        } else {
            this.processMarkup(fragments, fallbackMarkers, html, 0, html.length());
        }
        return fragments;
    }

    private void processMarkup(List<Fragment> fragments, List<FallbackMarker> fallbackMarkers, String html, int startIdx, int endIdx) {
        int idx = startIdx;
        for (FallbackMarker fe : fallbackMarkers) {
            if (idx > fe.start) continue;
            if (fe.start > endIdx) break;
            if (idx < fe.start) {
                fragments.add(Fragment.raw(html.substring(idx, fe.start)));
            }
            fragments.add(this.toFallback(html, fe));
            idx = fe.end;
        }
        if (idx < endIdx) {
            fragments.add(Fragment.raw(html.substring(idx, endIdx)));
        }
    }

    private Fragment toFallback(String html, FallbackMarker fm) {
        String snippet = html.substring(fm.start, fm.end);
        return Fragment.fallback(snippet, fm.id).setAttribute("fallback-strategy", fm.strategy);
    }

    private Fragment toSnippet(String[] ids, String html, int startIdx, int endIdx) {
        String snippet = html.substring(startIdx, endIdx);
        Matcher matcher = this.snippetPatterns.getSnippetWithFallbackPattern().matcher(snippet);
        String fallback = matcher.matches() ? matcher.group(2) : this.defaultFallback;
        return Fragment.snippet(Arrays.asList(ids), snippet, fallback);
    }

    private List<FallbackMarker> getFallbackMarkers(String html) {
        Matcher matcher = this.snippetPatterns.getFallbackPattern().matcher(html);
        ArrayList<FallbackMarker> result = new ArrayList<FallbackMarker>();
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String snippet = html.substring(matchResult.start(), matchResult.end());
            Matcher strategyMatcher = this.snippetPatterns.getFallbackWithStrategyPattern().matcher(snippet);
            String strategy = strategyMatcher.matches() ? strategyMatcher.group(2) : null;
            result.add(new FallbackMarker(matchResult.start(), matchResult.end(), matcher.group(1), strategy));
        }
        return result;
    }

    private class FallbackMarker {
        int start;
        int end;
        String id;
        String strategy;

        FallbackMarker(int startIndex, int endIndex, String id, String strategy) {
            this.start = startIndex;
            this.end = endIndex;
            this.id = id;
            this.strategy = strategy;
        }
    }
}

