/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.assembler;

import io.knotx.fragments.api.Fragment;
import io.knotx.server.api.context.RequestContext;
import io.knotx.server.api.context.RequestEvent;
import io.knotx.server.api.handler.DefaultRequestContextEngine;
import io.knotx.server.api.handler.RequestContextEngine;
import io.knotx.server.api.handler.RequestEventHandlerResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class FragmentsAssemblerHandler
implements Handler<RoutingContext> {
    private static final String MISSING_FRAGMENTS_PAYLOAD = "Expected 'fragments' in the routing context are missing!";
    private final RequestContextEngine engine = new DefaultRequestContextEngine(this.getClass().getSimpleName());

    FragmentsAssemblerHandler() {
    }

    public void handle(RoutingContext context) {
        RequestContext requestContext = (RequestContext)context.get("requestContext");
        try {
            RequestEventHandlerResult result = this.joinFragmentsBodies(context, requestContext.getRequestEvent());
            this.engine.processAndSaveResult(result, context, requestContext);
        }
        catch (Exception e) {
            this.engine.handleFatal(context, requestContext, (Throwable)e);
        }
    }

    RequestEventHandlerResult joinFragmentsBodies(RoutingContext context, RequestEvent requestEvent) {
        List fragments = (List)context.get("fragments");
        String responseBody = Optional.ofNullable(fragments).map(this::toResponseBody).orElseThrow(() -> new IllegalStateException(MISSING_FRAGMENTS_PAYLOAD));
        return this.createSuccessResponse(requestEvent, responseBody);
    }

    private String toResponseBody(List<Fragment> fragments) {
        return fragments.stream().map(Fragment::getBody).collect(Collectors.joining());
    }

    private RequestEventHandlerResult createSuccessResponse(RequestEvent inputContext, String responseBody) {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        headers.add(HttpHeaders.CONTENT_LENGTH.toString().toLowerCase(), Integer.toString(responseBody.length()));
        return RequestEventHandlerResult.success((RequestEvent)inputContext).withBody(Buffer.buffer((String)responseBody)).withHeaders(headers);
    }
}

