/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher;

import io.knotx.launcher.KnotxStarterVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.launcher.VertxLifecycleHooks;
import io.vertx.core.impl.launcher.commands.BareCommand;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;

@Name(value="run-knotx")
@Summary(value="Runs a Knot.x instance")
public class KnotxCommand
extends BareCommand {
    private static final int KNOTX_MISSING_OR_EMPTY_CONFIGURATION_EXIT_CODE = 30;
    private static final String DEFAULT_LOADER_FILE = "bootstrap.json";
    private DeploymentOptions deploymentOptions;
    private String config;
    private boolean ha;
    private boolean cluster;
    private static final String KNOTX_STARTER_VERTICLE = KnotxStarterVerticle.class.getName();

    @Option(longName="ha", acceptValue=false, flag=true)
    @Description(value="If specified the Knot.x will be deployed as a high availability (HA) deployment. This means it can fail over to any other nodes in the cluster started with the same HA group.")
    public void setHighAvailability(boolean ha) {
        this.ha = ha;
    }

    @Option(longName="cluster", acceptValue=false, flag=true)
    @Description(value="If specified then the Knot.x instance will form a cluster with any other Knotx.x instances on the network.")
    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    @Option(longName="conf", argName="config")
    @Description(value="Specifies path to the config loader json Knot.x requires to start. If not specified a 'bootstrap.json' in the class path is to be used.")
    public void setConfig(String path) {
        this.config = path != null ? path : null;
    }

    public void setUp(ExecutionContext context) throws CLIException {
        super.setUp(context);
    }

    public boolean isClustered() {
        return this.cluster || this.ha;
    }

    public boolean getHA() {
        return this.ha;
    }

    public void run() {
        JsonObject conf = this.getConfiguration();
        if (conf == null) {
            ExecUtils.exit((int)30);
        }
        this.afterConfigParsed(conf);
        super.run(this::afterStoppingVertx);
        if (this.vertx == null) {
            ExecUtils.exitBecauseOfVertxInitializationIssue();
        }
        if (this.vertx instanceof VertxInternal) {
            ((VertxInternal)this.vertx).addCloseHook(completionHandler -> {
                try {
                    this.beforeStoppingVertx(this.vertx);
                    completionHandler.handle((Object)Future.succeededFuture());
                }
                catch (Exception e) {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)e));
                }
            });
        }
        this.deploymentOptions = new DeploymentOptions();
        this.configureFromSystemProperties(this.deploymentOptions, "vertx.deployment.options.");
        this.deploymentOptions.setConfig(conf).setHa(this.ha);
        this.beforeDeployingVerticle(this.deploymentOptions);
        this.deploy();
    }

    protected void deploy() {
        this.deploy(KNOTX_STARTER_VERTICLE, this.vertx, this.deploymentOptions, res -> {
            if (res.failed()) {
                res.cause().printStackTrace();
                this.handleDeployFailed(res.cause());
            }
        });
    }

    private void handleDeployFailed(Throwable cause) {
        if (this.executionContext.main() instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)this.executionContext.main()).handleDeployFailed(this.vertx, KNOTX_STARTER_VERTICLE, this.deploymentOptions, cause);
        } else {
            ExecUtils.exitBecauseOfVertxDeploymentIssue();
        }
    }

    protected JsonObject getConfiguration() {
        JsonObject conf;
        if (this.config == null) {
            URL bootstrap = ((Object)((Object)this)).getClass().getClassLoader().getResource(DEFAULT_LOADER_FILE);
            if (bootstrap != null) {
                this.log.info((Object)"Loading configuration from classpath: {}.", new Object[]{bootstrap.toExternalForm()});
                try {
                    conf = this.scanConfig(bootstrap.openStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            this.log.error((Object)"The '{}' not found on the classpath", new Object[]{DEFAULT_LOADER_FILE});
            return null;
        }
        try {
            File configFile = new File(this.config);
            this.log.info((Object)"Loading configuration from {}", new Object[]{configFile.toURI()});
            conf = this.scanConfig(new FileInputStream(configFile));
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"The -conf option does not point to an existing file");
            e.printStackTrace();
            return null;
        }
        return conf;
    }

    private JsonObject scanConfig(InputStream is) {
        JsonObject conf;
        try (Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");){
            String sconf = scanner.next();
            try {
                conf = new JsonObject(sconf);
            }
            catch (DecodeException e) {
                this.log.error((Object)("Configuration file " + sconf + " does not contain a valid JSON object"));
                JsonObject jsonObject = null;
                if (scanner != null) {
                    if (var4_3 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var4_3.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
                return jsonObject;
            }
        }
        return conf;
    }

    protected void beforeDeployingVerticle(DeploymentOptions deploymentOptions) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).beforeDeployingVerticle(deploymentOptions);
        }
    }

    protected void afterConfigParsed(JsonObject config) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).afterConfigParsed(config);
        }
    }

    protected void beforeStoppingVertx(Vertx vertx) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).beforeStoppingVertx(vertx);
        }
    }

    protected void afterStoppingVertx() {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).afterStoppingVertx();
        }
    }
}

