/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher;

import com.google.common.collect.Lists;
import io.knotx.launcher.BadKnotxConfigurationException;
import io.knotx.launcher.ModuleDescriptor;
import io.knotx.launcher.exception.ModulesUnsupportedSyntaxException;
import io.knotx.launcher.helper.LogoPrintHelper;
import io.knotx.launcher.property.SystemProperties;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.config.ConfigRetriever;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class KnotxStarterVerticle
extends AbstractVerticle {
    private static final String MODULES_KEY = "modules";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxStarterVerticle.class);
    private static final String FILE_STORE = "file";
    private static final String KNOTX_HOME_PROPERTY = "knotx.home";
    private List<ModuleDescriptor> deployedModules;
    private ConfigRetriever configRetriever;
    private SystemProperties systemProperties;

    public void start(Future<Void> startFuture) {
        this.systemProperties = new SystemProperties();
        LogoPrintHelper.printLogo();
        try {
            JsonObject configOptions = this.getConfigRetrieverOptions(this.config());
            this.configRetriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions(configOptions));
            this.configRetriever.listen(conf -> {
                if (!this.deployedModules.isEmpty()) {
                    LOGGER.warn((Object)"Configuration changed - Re-deploying Knot.x");
                    Observable.fromIterable(this.deployedModules).flatMap(item -> this.vertx.rxUndeploy(item.getDeploymentId()).toObservable()).collect(Lists::newArrayList, ArrayList::add).subscribe(success -> {
                        LOGGER.warn((Object)"Knot.x STOPPED.");
                        this.deployVerticles(conf.getNewConfiguration(), null);
                    }, error -> {
                        LOGGER.error((Object)"Unable to undeploy verticles", error);
                        startFuture.fail(error);
                    });
                }
            });
            this.configRetriever.getConfig(ar -> {
                if (ar.succeeded()) {
                    JsonObject configuration = (JsonObject)ar.result();
                    this.deployVerticles(configuration, startFuture);
                } else {
                    LOGGER.fatal((Object)"Unable to start Knot.x", ar.cause());
                    startFuture.fail(ar.cause());
                }
            });
        }
        catch (BadKnotxConfigurationException ex) {
            startFuture.fail((Throwable)((Object)ex));
        }
    }

    private JsonObject getConfigRetrieverOptions(JsonObject config) {
        if (this.config().getJsonObject("configRetrieverOptions") == null) {
            throw new BadKnotxConfigurationException("Missing 'configRetrieverOptions' in the main config file");
        }
        JsonObject configOptions = config.getJsonObject("configRetrieverOptions");
        configOptions.getJsonArray("stores").stream().map(item -> (JsonObject)item).forEach(store -> {
            if (FILE_STORE.equals(store.getString("type"))) {
                store.getJsonObject("config").put("path", this.resolveConfigPath(store.getJsonObject("config").getString("path")));
            }
        });
        return configOptions;
    }

    private String resolveConfigPath(String path) {
        String resolvedPath = path;
        if (path.startsWith("${KNOTX_HOME}")) {
            Optional<String> home = this.systemProperties.getProperty(KNOTX_HOME_PROPERTY);
            if (home.isPresent()) {
                resolvedPath = path.replace("${KNOTX_HOME}", home.get());
            } else if (System.getenv("KNOTX_HOME") == null) {
                throw new BadKnotxConfigurationException("Unable to resolve ${KNOTX_HOME} for " + path + ". System property 'knotx.home', or environment variable 'KNOTX_HOME' are not set");
            }
        }
        return resolvedPath;
    }

    private void deployVerticles(JsonObject config, Future<Void> completion) {
        LOGGER.info((Object)"STARTING Knot.x");
        Observable.just((Object)config).flatMap(c -> Observable.fromIterable(this.getModulesFromConfigOrEmpty((JsonObject)c))).map(entry -> ModuleDescriptor.fromConfig((String)entry.getKey(), (String)entry.getValue(), config)).flatMap(this::deployVerticle).reduce(new ArrayList(), (accumulator, item) -> {
            accumulator.add(item);
            return accumulator;
        }).subscribe(deployments -> {
            this.deployedModules = Lists.newArrayList((Iterable)deployments);
            LOGGER.info((Object)"Instance modules: {}", new Object[]{this.buildMessage()});
            if (completion != null) {
                if (this.anyRequiredModuleFailed(this.deployedModules)) {
                    String message = "Knot.x start FAILED: some mandatory modules deployment failed";
                    LOGGER.error((Object)"Knot.x start FAILED: some mandatory modules deployment failed");
                    completion.fail("Knot.x start FAILED: some mandatory modules deployment failed");
                } else {
                    LOGGER.info((Object)"Knot.x STARTED successfully");
                    completion.complete();
                }
            }
        }, error -> {
            LOGGER.error((Object)"Verticle could not be deployed", error);
            if (completion != null) {
                completion.fail(error);
            }
        });
    }

    private Set<Map.Entry<String, String>> getModulesFromConfigOrEmpty(JsonObject config) {
        Object modulesObject = config.getMap().get(MODULES_KEY);
        if (this.isModulesPropertyValid(modulesObject)) {
            Optional<JsonObject> jsonObject = Optional.ofNullable(config.getJsonObject(MODULES_KEY));
            return jsonObject.map(json -> json.getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())))).orElse(Collections.emptyMap()).entrySet();
        }
        throw new ModulesUnsupportedSyntaxException(config);
    }

    private boolean isModulesPropertyValid(Object modulesObject) {
        return modulesObject == null || modulesObject instanceof Map || modulesObject instanceof JsonObject;
    }

    private boolean anyRequiredModuleFailed(List<ModuleDescriptor> deployedModules) {
        return deployedModules.stream().anyMatch(md -> md.getState() == ModuleDescriptor.DeploymentState.FAILED && md.isRequired());
    }

    private Observable<ModuleDescriptor> deployVerticle(ModuleDescriptor module) {
        return this.vertx.rxDeployVerticle(module.getName(), module.getDeploymentOptions()).map(deployId -> new ModuleDescriptor(module).setDeploymentId((String)deployId).setState(ModuleDescriptor.DeploymentState.SUCCESS)).doOnError(error -> LOGGER.error((Object)"Can't deploy {}={}", new Object[]{module.getAlias(), module.getName(), error})).onErrorResumeNext(err -> Single.just((Object)new ModuleDescriptor(module).setState(ModuleDescriptor.DeploymentState.FAILED))).toObservable();
    }

    private String buildMessage() {
        return System.lineSeparator() + this.deployedModules.stream().map(ModuleDescriptor::toLogEntry).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator();
    }
}

