/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class ModuleDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDescriptor.class);
    private static final String MODULE_DEFAULT_PREFIX = "java:";
    private static final String CONFIG_OVERRIDE = "config";
    private static final String MODULE_OPTIONS = "options";
    private static final String REQUIRED_KEY = "required";
    private String alias;
    private String name;
    private String deploymentId;
    private DeploymentState state = DeploymentState.UNKNOWN;
    private DeploymentOptions deploymentOptions;
    private boolean required = true;

    private ModuleDescriptor(String alias, String name) {
        this.alias = alias;
        this.name = name.indexOf(58) != -1 ? name : MODULE_DEFAULT_PREFIX + name;
    }

    ModuleDescriptor(ModuleDescriptor other) {
        this.alias = other.alias;
        this.name = other.name;
        this.deploymentId = other.deploymentId;
        this.state = other.state;
        this.deploymentOptions = other.deploymentOptions;
        this.required = other.required;
    }

    static ModuleDescriptor fromConfig(String alias, String name, JsonObject json) {
        ModuleDescriptor descriptor = new ModuleDescriptor(alias, name);
        ModuleDescriptor.parseJson(json, descriptor);
        return descriptor;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public ModuleDescriptor setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public ModuleDescriptor setState(DeploymentState state) {
        this.state = state;
        return this;
    }

    public DeploymentState getState() {
        return this.state;
    }

    public DeploymentOptions getDeploymentOptions() {
        return this.deploymentOptions;
    }

    public boolean isRequired() {
        return this.required;
    }

    String toLogEntry() {
        return this.getState().getMessage() + " " + this.deploymentOptions.getInstances() + " instance(s) of " + (this.required ? "required " : "optional ") + this.alias + " (" + this.name + ")" + (this.deploymentId != null ? " [" + this.deploymentId + "]" : "");
    }

    public String toString() {
        return "ModuleDescriptor{alias='" + this.alias + '\'' + ", name='" + this.name + '\'' + ", deploymentId='" + this.deploymentId + '\'' + ", state=" + (Object)((Object)this.state) + ", deploymentOptions=" + this.deploymentOptions + ", required=" + this.required + '}';
    }

    private static void parseJson(JsonObject json, ModuleDescriptor descriptor) {
        descriptor.deploymentOptions = new DeploymentOptions();
        if (json.containsKey(CONFIG_OVERRIDE)) {
            if (json.getJsonObject(CONFIG_OVERRIDE).containsKey(descriptor.alias)) {
                JsonObject moduleConfig = json.getJsonObject(CONFIG_OVERRIDE).getJsonObject(descriptor.alias);
                if (moduleConfig.containsKey(MODULE_OPTIONS)) {
                    descriptor.deploymentOptions.fromJson(moduleConfig.getJsonObject(MODULE_OPTIONS));
                    descriptor.required = moduleConfig.getJsonObject(MODULE_OPTIONS).getBoolean(REQUIRED_KEY, Boolean.valueOf(true));
                } else {
                    LOGGER.warn((Object)"Module '{}' has config, but missing 'options' object. Default configuration is to be used", new Object[]{descriptor.alias});
                }
            } else {
                LOGGER.warn((Object)"Module '{}' if not configured in the config file. Used default configuration", new Object[]{descriptor.alias});
            }
        }
    }

    public static enum DeploymentState {
        UNKNOWN("Unknown state"),
        SUCCESS("Deployed"),
        FAILED("Failed to deploy");

        private final String message;

        private DeploymentState(String message) {
            this.message = message;
        }

        private String getMessage() {
            return this.message;
        }
    }
}

