/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.launcher.property;

import io.knotx.launcher.property.DefaultSystemPropertyProvider;
import io.knotx.launcher.property.SystemPropertyProvider;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;

public class SystemProperties {
    private final LinkedList<Properties> stores = new LinkedList();

    public SystemProperties() {
        ServiceLoader<SystemPropertyProvider> allProviders = ServiceLoader.load(SystemPropertyProvider.class);
        allProviders.forEach(provider -> {
            if (provider.getClass() == DefaultSystemPropertyProvider.class) {
                this.stores.addFirst(provider.getProperties());
            } else {
                this.stores.addLast(provider.getProperties());
            }
        });
    }

    public Optional<String> getProperty(String key) {
        return this.stores.stream().map(properties -> properties.getProperty(key)).filter(Objects::nonNull).findFirst();
    }
}

