/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.stack.command;

import io.knotx.stack.model.Stack;
import io.knotx.stack.model.StackResolution;
import io.knotx.stack.model.StackResolutionOptions;
import io.knotx.stack.utils.Home;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Hidden;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.spi.launcher.DefaultCommand;
import java.io.File;
import java.util.List;

@Name(value="resolve")
@Summary(value="Resolve the knot.x stack according to the content the stack description.")
@Description(value="Synchronize the content of a knot.x distribution based on the description given in a 'json' file. From the 'KNOTX_HOME' directory, launch it with: 'bin/knotx resolve'.")
public class ResolveCommand
extends DefaultCommand {
    private String directory;
    private String descriptor;
    private boolean failOnConflict;
    private String localRepository;
    private List<String> remoteRepositories;
    private String httpProxy;
    private String httpsProxy;
    private boolean disableCache;
    private boolean disableCacheForSnapshots;
    private File cacheFile;

    @Option(longName="dir")
    @Description(value="The directory containing the artifacts composing the stack. Defaults to the '$KNOTX_HOME/lib' directory, if $KNOTX_HOME is set, './lib' otherwise.")
    public void setDirectory(String file) {
        this.directory = file;
    }

    @Argument(index=0, required=false, argName="stack-descriptor")
    @DefaultValue(value="knotx-stack.json")
    @Description(value="The path to the stack descriptor. Defaults to '$KNOTX_HOME/knotx-stack.json', if $KNOTX_HOME is set, './knotx-stack.json' otherwise.")
    public void setStackDescriptor(String file) {
        this.descriptor = file;
    }

    @Option(longName="fail-on-conflict", flag=true)
    @DefaultValue(value="false")
    @Description(value="Set whether or not the resolver should fail or conflict or just log a warning. Disabled by default.")
    public void setFailOnConflict(boolean fail) {
        this.failOnConflict = fail;
    }

    @Option(longName="local-repo")
    @Description(value="Set the path to the local Maven repository. Defaults to '~/.m2/repository'.")
    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    @Option(longName="remote-repo", acceptMultipleValues=true)
    @Description(value="Set the path to a remote Maven repository. Can be set multiple times.")
    public void setRemoteRepositories(List<String> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    @Option(longName="http-proxy")
    @Description(value="Set the HTTP proxy address if any.")
    public void setHttpProxy(String p) {
        this.httpProxy = p;
    }

    @Option(longName="https-proxy")
    @Description(value="Set the HTTPS proxy address if any.")
    public void setHttpsProxy(String p) {
        this.httpsProxy = p;
    }

    @Option(longName="no-cache", flag=true)
    @Description(value="Disable the resolver cache")
    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    @Option(longName="no-cache-for-snapshots", flag=true)
    @Description(value="Disable the caching of snapshot resolution")
    public void setDisableCacheForSnapshots(boolean disableCache) {
        this.disableCacheForSnapshots = disableCache;
    }

    @Option(longName="cache-file")
    @Hidden
    public void setCacheLocation(File cache) {
        this.cacheFile = cache;
    }

    public void run() throws CLIException {
        File descriptorFile = new File(this.descriptor);
        if (!descriptorFile.isFile() && Home.getKnotxHome() != null) {
            descriptorFile = new File(Home.getKnotxHome(), this.descriptor);
        }
        if (!descriptorFile.isFile()) {
            String message = "Cannot find the stack descriptor. Have been tried: \n\t - ./" + descriptorFile;
            if (Home.getKnotxHome() != null) {
                message = message + "\n\t - " + descriptorFile.getAbsolutePath();
            }
            throw new CLIException(message);
        }
        File lib = this.directory == null ? (Home.getKnotxHome() != null ? new File(Home.getKnotxHome(), "lib") : new File("lib")) : new File(this.directory);
        this.out().println("lib directory set to: " + lib.getAbsolutePath());
        Stack stack = Stack.fromDescriptor(descriptorFile);
        StackResolutionOptions options = new StackResolutionOptions().setFailOnConflicts(this.failOnConflict).setCacheDisabled(this.disableCache).setCacheDisabledForSnapshots(this.disableCacheForSnapshots).setCacheFile(this.cacheFile);
        if (this.localRepository != null) {
            options.setLocalRepository(this.localRepository);
        }
        if (this.remoteRepositories != null) {
            options.setRemoteRepositories((List)this.remoteRepositories);
        }
        options.setHttpProxy(this.httpProxy);
        options.setHttpsProxy(this.httpsProxy);
        StackResolution resolution = new StackResolution(stack, lib, options);
        resolution.resolve();
    }
}

