/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.stack.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.knotx.stack.model.Dependency;
import io.knotx.stack.utils.Filtering;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Stack {
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private Map<String, String> variables = new LinkedHashMap<String, String>();

    public Stack addVariable(String key, String value) {
        this.variables.put(key, value);
        return this;
    }

    public Stack removeVariable(String key) {
        this.variables.remove(key);
        return this;
    }

    public Stack addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public Stack removeDependency(Dependency dependency) {
        this.dependencies.remove(dependency);
        return this;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void applyFiltering() {
        LinkedHashMap<Object, Object> properties = new LinkedHashMap<Object, Object>();
        properties.putAll(this.variables);
        properties.putAll(System.getProperties());
        this.dependencies.stream().forEach(dependency -> {
            dependency.setGroupId(Filtering.filter(dependency.getGroupId(), properties));
            dependency.setArtifactId(Filtering.filter(dependency.getArtifactId(), properties));
            dependency.setVersion(Filtering.filter(dependency.getVersion(), properties));
            dependency.setClassifier(Filtering.filter(dependency.getClassifier(), properties));
            dependency.setType(Filtering.filter(dependency.getType(), properties));
        });
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public static Stack fromDescriptor(File descriptor) {
        ObjectMapper mapper = new ObjectMapper();
        mapper = mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        try {
            return (Stack)mapper.readValue(descriptor, Stack.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load stack from " + descriptor.getAbsolutePath(), e);
        }
    }
}

