/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.stack.resolver;

import io.knotx.stack.resolver.ResolutionOptions;
import io.knotx.stack.resolver.Resolver;
import io.knotx.stack.resolver.ResolverOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.collection.CollectRequest;
import shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import shaded.org.eclipse.aether.graph.Dependency;
import shaded.org.eclipse.aether.graph.DependencyFilter;
import shaded.org.eclipse.aether.graph.DependencyNode;
import shaded.org.eclipse.aether.graph.Exclusion;
import shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import shaded.org.eclipse.aether.repository.Authentication;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.repository.RepositoryPolicy;
import shaded.org.eclipse.aether.resolution.ArtifactRequest;
import shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import shaded.org.eclipse.aether.resolution.ArtifactResult;
import shaded.org.eclipse.aether.resolution.DependencyRequest;
import shaded.org.eclipse.aether.resolution.DependencyResolutionException;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.transport.file.FileTransporterFactory;
import shaded.org.eclipse.aether.transport.http.HttpTransporterFactory;
import shaded.org.eclipse.aether.util.filter.DependencyFilterUtils;
import shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;

public class ResolverImpl
implements Resolver {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"knotx-stack-resolver");
    public static final String REMOTE_SNAPSHOT_POLICY_SYS_PROP = "knotx.maven.snapshotPolicy";
    private final RepositorySystem system;
    private LocalRepository localRepo;
    private final List<RemoteRepository> remotes = new ArrayList<RemoteRepository>();

    public ResolverImpl(ResolverOptions options) {
        String localMavenRepo = options.getLocalRepository();
        List<String> remoteMavenRepos = options.getRemoteRepositories();
        String httpProxy = options.getHttpProxy();
        String httpsProxy = options.getHttpsProxy();
        DefaultServiceLocator locator = ResolverImpl.getDefaultServiceLocator();
        this.system = locator.getService(RepositorySystem.class);
        this.localRepo = new LocalRepository(localMavenRepo);
        Proxy proxy = this.getHttpProxy(httpProxy);
        Proxy secureProxy = this.getHttpsProxy(httpsProxy);
        this.configureRemoteRepositories(remoteMavenRepos, proxy, secureProxy);
    }

    private Proxy getHttpsProxy(String httpsProxy) {
        Proxy secureProxy = null;
        if (httpsProxy != null) {
            URL url = this.url(httpsProxy);
            Authentication authentication = ResolverImpl.extractAuth(url);
            secureProxy = new Proxy("https", url.getHost(), url.getPort(), authentication);
        }
        return secureProxy;
    }

    private Proxy getHttpProxy(String httpProxy) {
        Proxy proxy = null;
        if (httpProxy != null) {
            URL url = this.url(httpProxy);
            Authentication authentication = ResolverImpl.extractAuth(url);
            proxy = new Proxy("http", url.getHost(), url.getPort(), authentication);
        }
        return proxy;
    }

    private void configureRemoteRepositories(List<String> remoteMavenRepos, Proxy proxy, Proxy secureProxy) {
        int count = 0;
        for (String remote : remoteMavenRepos) {
            URL url = this.url(remote);
            Authentication auth = ResolverImpl.extractAuth(url);
            if (auth != null) {
                url = this.url(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
            }
            RemoteRepository.Builder builder = new RemoteRepository.Builder("repo" + count++, "default", url.toString());
            if (auth != null) {
                builder.setAuthentication(auth);
            }
            switch (url.getProtocol()) {
                case "http": {
                    if (proxy == null) break;
                    builder.setProxy(proxy);
                    break;
                }
                case "https": {
                    if (secureProxy == null) break;
                    builder.setProxy(secureProxy);
                }
            }
            this.customizeRemoteRepoBuilder(builder);
            RemoteRepository remoteRepo = builder.build();
            this.remotes.add(remoteRepo);
        }
    }

    private static DefaultServiceLocator getDefaultServiceLocator() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            @Override
            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                LOGGER.error((Object)("Service creation failure: " + exception.getMessage()), exception);
            }
        });
        return locator;
    }

    private URL url(String u) {
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("Cannot create url from " + u), (Throwable)e);
            throw new IllegalArgumentException("Invalid url " + u);
        }
    }

    private URL url(String protocol, String host, int port, String file) {
        try {
            return new URL(protocol, host, port, file);
        }
        catch (MalformedURLException e) {
            String url = "{protocol:" + protocol + ", host:" + host + ", port:" + port + ", file:" + file + "}";
            LOGGER.error((Object)("Cannot create url from " + url), (Throwable)e);
            throw new IllegalArgumentException("Invalid url " + url);
        }
    }

    public List<Artifact> resolve(Artifact artifact, boolean transitive, List<String> exclusions) {
        List<ArtifactResult> artifactResults;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(session, this.localRepo));
        LOGGER.info((Object)("Resolving " + artifact.toString()));
        DependencyFilter filter = DependencyFilterUtils.andFilter(DependencyFilterUtils.classpathFilter("compile"), (dependencyNode, list) -> {
            for (DependencyNode parent : list) {
                if (!parent.getDependency().isOptional()) continue;
                return false;
            }
            return !dependencyNode.getDependency().isOptional();
        }, (dependencyNode, list) -> {
            ArrayList<Exclusion> ex = new ArrayList<Exclusion>();
            for (DependencyNode parent : list) {
                ex.addAll(parent.getDependency().getExclusions());
            }
            for (Exclusion e : ex) {
                if (e.getArtifactId().equals(dependencyNode.getArtifact().getArtifactId()) && e.getGroupId().equals(dependencyNode.getArtifact().getGroupId())) {
                    return false;
                }
                for (DependencyNode parent : list) {
                    if (!e.getArtifactId().equals(parent.getArtifact().getArtifactId()) || !e.getGroupId().equals(parent.getArtifact().getGroupId())) continue;
                    return false;
                }
            }
            return true;
        }, (dependencyNode, list) -> {
            for (DependencyNode parent : list) {
                if (parent.getDependency().getScope().toLowerCase().equals("compile")) continue;
                return false;
            }
            return dependencyNode.getDependency().getScope().toLowerCase().equals("compile");
        });
        try {
            if (!transitive) {
                ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.remotes, null);
                artifactResults = Collections.singletonList(this.system.resolveArtifact(session, artifactRequest));
            } else {
                CollectRequest collectRequest = new CollectRequest();
                Dependency root = new Dependency(artifact, "compile").setExclusions(exclusions.stream().map(e -> {
                    String[] segments = e.split(":");
                    if (segments.length != 2) {
                        throw new IllegalStateException("Invalid exclusion format: " + e + " - exclusion are structured as follows: groupId:artifactId");
                    }
                    return new Exclusion(segments[0], segments[1], null, null);
                }).collect(Collectors.toList()));
                collectRequest.setRoot(root);
                collectRequest.setRepositories(this.remotes);
                DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, filter);
                artifactResults = this.system.resolveDependencies(session, dependencyRequest).getArtifactResults();
            }
        }
        catch (ArtifactResolutionException | DependencyResolutionException e2) {
            throw new IllegalArgumentException("Cannot resolve artifact " + artifact.toString() + " in maven repositories: " + e2.getMessage());
        }
        catch (NullPointerException e3) {
            throw new IllegalArgumentException("Cannot find module " + artifact.toString() + ". Maybe repository URL is invalid?");
        }
        List<Artifact> artifacts = artifactResults.stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
        LOGGER.trace((Object)("Dependencies resolved by " + artifact.getArtifactId() + " => " + artifacts));
        return artifacts;
    }

    protected void customizeRemoteRepoBuilder(RemoteRepository.Builder builder) {
        String updatePolicy = System.getProperty(REMOTE_SNAPSHOT_POLICY_SYS_PROP);
        if (updatePolicy != null && !updatePolicy.isEmpty()) {
            builder.setSnapshotPolicy(new RepositoryPolicy(true, updatePolicy, "warn"));
        }
    }

    private static Authentication extractAuth(URL url) {
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            int sep = userInfo.indexOf(58);
            if (sep != -1) {
                authBuilder.addUsername(userInfo.substring(0, sep));
                authBuilder.addPassword(userInfo.substring(sep + 1));
            } else {
                authBuilder.addUsername(userInfo);
            }
            return authBuilder.build();
        }
        return null;
    }

    @Override
    public List<Artifact> resolve(String gacv, ResolutionOptions options) {
        DefaultArtifact artifact = new DefaultArtifact(gacv);
        return this.resolve(artifact, options.isWithTransitive(), options.getExclusions());
    }
}

