/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.http.FormattedHeader;
import shaded.org.apache.http.Header;
import shaded.org.apache.http.HeaderElement;
import shaded.org.apache.http.annotation.NotThreadSafe;
import shaded.org.apache.http.cookie.Cookie;
import shaded.org.apache.http.cookie.CookieOrigin;
import shaded.org.apache.http.cookie.MalformedCookieException;
import shaded.org.apache.http.impl.cookie.BasicCommentHandler;
import shaded.org.apache.http.impl.cookie.BasicExpiresHandler;
import shaded.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import shaded.org.apache.http.impl.cookie.BasicPathHandler;
import shaded.org.apache.http.impl.cookie.BasicSecureHandler;
import shaded.org.apache.http.impl.cookie.CookieSpecBase;
import shaded.org.apache.http.impl.cookie.NetscapeDomainHandler;
import shaded.org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import shaded.org.apache.http.message.BufferedHeader;
import shaded.org.apache.http.message.ParserCursor;
import shaded.org.apache.http.util.Args;
import shaded.org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class NetscapeDraftSpec
extends CookieSpecBase {
    protected static final String EXPIRES_PATTERN = "EEE, dd-MMM-yy HH:mm:ss z";
    private final String[] datepatterns;

    public NetscapeDraftSpec(String[] datepatterns) {
        this.datepatterns = datepatterns != null ? (String[])datepatterns.clone() : new String[]{EXPIRES_PATTERN};
        this.registerAttribHandler("path", new BasicPathHandler());
        this.registerAttribHandler("domain", new NetscapeDomainHandler());
        this.registerAttribHandler("max-age", new BasicMaxAgeHandler());
        this.registerAttribHandler("secure", new BasicSecureHandler());
        this.registerAttribHandler("comment", new BasicCommentHandler());
        this.registerAttribHandler("expires", new BasicExpiresHandler(this.datepatterns));
    }

    public NetscapeDraftSpec() {
        this(null);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        ParserCursor cursor;
        CharArrayBuffer buffer;
        Args.notNull(header, "Header");
        Args.notNull(origin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
        } else {
            String s2 = header.getValue();
            if (s2 == null) {
                throw new MalformedCookieException("Header value is null");
            }
            buffer = new CharArrayBuffer(s2.length());
            buffer.append(s2);
            cursor = new ParserCursor(0, buffer.length());
        }
        return this.parse(new HeaderElement[]{parser.parseHeader(buffer, cursor)}, origin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notEmpty(cookies, "List of cookies");
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i2 = 0; i2 < cookies.size(); ++i2) {
            Cookie cookie = cookies.get(i2);
            if (i2 > 0) {
                buffer.append("; ");
            }
            buffer.append(cookie.getName());
            String s2 = cookie.getValue();
            if (s2 == null) continue;
            buffer.append("=");
            buffer.append(s2);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "netscape";
    }
}

