/*
 * Decompiled with CFR 0.152.
 */
package io.kokuwa.maven.helm;

import io.kokuwa.maven.helm.AbstractHelmMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="dependency-build", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class DependencyBuildMojo
extends AbstractHelmMojo {
    @Parameter(property="helm.dependency-build.skip", defaultValue="false")
    private boolean skipDependencyBuild;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipDependencyBuild) {
            this.getLog().info((CharSequence)"Skip dependency build");
            return;
        }
        for (String inputDirectory : this.getChartDirectories(this.getChartDirectory())) {
            this.getLog().info((CharSequence)("Build chart dependencies for " + inputDirectory + "..."));
            this.callCli(this.getHelmExecuteablePath() + " dependency build " + inputDirectory + (StringUtils.isNotEmpty((String)this.getRegistryConfig()) ? " --registry-config=" + this.getRegistryConfig() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryCache()) ? " --repository-cache=" + this.getRepositoryCache() : "") + (StringUtils.isNotEmpty((String)this.getRepositoryConfig()) ? " --repository-config=" + this.getRepositoryConfig() : ""), "Failed to resolve dependencies");
        }
    }

    public DependencyBuildMojo setSkipDependencyBuild(boolean skipDependencyBuild) {
        this.skipDependencyBuild = skipDependencyBuild;
        return this;
    }
}

